/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.categorynav;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.CategoryService;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;
import org.drools.guvnor.client.widgets.categorynav.CategorySelectHandler;

public class CategoryExplorerWidget
extends Composite
implements SelectionHandler<TreeItem>,
OpenHandler<TreeItem> {
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private Tree navTreeWidget = new Tree();
    private VerticalPanel panel = new VerticalPanel();
    private CategoryServiceAsync categoryService = (CategoryServiceAsync)GWT.create(CategoryService.class);
    private CategorySelectHandler categorySelectHandler;
    private String selectedPath;
    private Panel emptyCategories;

    public void setTreeSize(String width) {
        this.navTreeWidget.setWidth(width);
    }

    public CategoryExplorerWidget(CategorySelectHandler handler) {
        this.panel.add((Widget)this.navTreeWidget);
        this.categorySelectHandler = handler;
        this.loadInitialTree();
        this.initWidget((Widget)this.panel);
        this.navTreeWidget.addSelectionHandler((SelectionHandler)this);
        this.navTreeWidget.addOpenHandler((OpenHandler)this);
        this.setStyleName("category-explorer-Tree");
    }

    public void refresh() {
        this.navTreeWidget.removeItems();
        this.selectedPath = null;
        this.loadInitialTree();
    }

    public void showEmptyTree() {
        if (this.emptyCategories == null) {
            AbsolutePanel p = new AbsolutePanel();
            p.add((Widget)new HTML(constants.NoCategoriesCreatedYetTip()));
            Button b = new Button(constants.Refresh());
            b.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    CategoryExplorerWidget.this.refresh();
                }
            });
            p.add((Widget)b);
            p.setStyleName("small-Text");
            this.emptyCategories = p;
            this.panel.add((Widget)this.emptyCategories);
        }
        this.navTreeWidget.setVisible(false);
        this.emptyCategories.setVisible(true);
    }

    private void loadInitialTree() {
        this.navTreeWidget.addItem(constants.PleaseWait());
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                CategoryExplorerWidget.this.categoryService.loadChildCategories("/", (AsyncCallback<String[]>)new GenericCallback<String[]>(){

                    public void onSuccess(String[] categories) {
                        CategoryExplorerWidget.this.selectedPath = null;
                        CategoryExplorerWidget.this.navTreeWidget.removeItems();
                        TreeItem root = new TreeItem();
                        root.setHTML(AbstractImagePrototype.create((ImageResource)images.desc()).getHTML());
                        CategoryExplorerWidget.this.navTreeWidget.addItem(root);
                        if (categories.length == 0) {
                            CategoryExplorerWidget.this.showEmptyTree();
                        } else {
                            CategoryExplorerWidget.this.hideEmptyTree();
                        }
                        for (String category : categories) {
                            TreeItem it = new TreeItem();
                            it.setHTML(AbstractImagePrototype.create((ImageResource)images.categorySmall()).getHTML() + CategoryExplorerWidget.this.h(category));
                            it.setUserObject((Object)category);
                            it.addItem((TreeItem)new PendingItem());
                            root.addItem(it);
                        }
                        root.setState(true);
                    }
                });
            }
        });
    }

    private String h(String cat) {
        return cat.replace("<", "&lt;").replace(">", "&gt;");
    }

    private void hideEmptyTree() {
        if (this.emptyCategories != null) {
            this.emptyCategories.setVisible(false);
        }
        this.navTreeWidget.setVisible(true);
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        this.selectedPath = this.getPath((TreeItem)event.getSelectedItem());
        this.categorySelectHandler.selected(this.selectedPath);
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getTarget();
        if (this.hasBeenLoaded(item)) {
            return;
        }
        final TreeItem root = item;
        this.selectedPath = this.getPath(item);
        this.categoryService.loadChildCategories(this.selectedPath, (AsyncCallback<String[]>)new GenericCallback<String[]>(){

            public void onSuccess(String[] list) {
                TreeItem child = root.getChild(0);
                if (child instanceof PendingItem) {
                    child.setVisible(false);
                }
                for (String aList : list) {
                    TreeItem it = new TreeItem();
                    it.setHTML(AbstractImagePrototype.create((ImageResource)images.categorySmall()).getHTML() + CategoryExplorerWidget.this.h(aList));
                    it.setUserObject((Object)aList);
                    it.addItem((TreeItem)new PendingItem());
                    root.addItem(it);
                }
            }
        });
    }

    private boolean hasBeenLoaded(TreeItem item) {
        return item.getChildCount() != 1 || !(item.getChild(0) instanceof PendingItem);
    }

    private String getPath(TreeItem item) {
        String categoryPath = (String)item.getUserObject();
        if (categoryPath == null) {
            return null;
        }
        TreeItem parent = item.getParentItem();
        while (parent.getUserObject() != null) {
            categoryPath = (String)parent.getUserObject() + "/" + categoryPath;
            parent = parent.getParentItem();
        }
        return categoryPath;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isSelected() {
        return this.selectedPath != null;
    }

    private static class PendingItem
    extends TreeItem {
        public PendingItem() {
            super(constants.PleaseWait());
        }
    }
}

