/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.io.File;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.drools.workbench.jcr2vfsmigration.VfsImporterLauncher;
import org.junit.Before;
import org.junit.Test;

public class MortgagesRepoImportTest {
    private File outputVfsRepo = new File("target/vfs-importer-tests/mortgages-repo-import");
    private File jcrExportDir = new File("target/vfs-importer-tests/mortgages-jcr-export");

    @Before
    public void setup() throws Exception {
        FileUtils.deleteDirectory((File)this.outputVfsRepo);
        FileUtils.forceMkdir((File)this.jcrExportDir);
        FileUtils.cleanDirectory((File)this.jcrExportDir);
        File jcrExportZip = new File(Class.class.getResource("/jcr-export-xml.zip").getFile());
        MortgagesRepoImportTest.unzipFile(jcrExportZip, this.jcrExportDir);
    }

    @Test
    public void testImportMortgagesRepo() {
        String[] params = new String[]{"-i", this.jcrExportDir.getAbsolutePath(), "-o", this.outputVfsRepo.getAbsolutePath()};
        VfsImporterLauncher launcher = new VfsImporterLauncher();
        launcher.run(params);
    }

    private static void unzipFile(File zipFile, File outputDir) {
        try {
            new ZipFile(zipFile).extractAll(outputDir.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new RuntimeException("Can't unzip file '" + zipFile.getAbsolutePath() + "' into dir '" + outputDir.getAbsolutePath() + "'!", e);
        }
    }
}

