/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.service;

import java.util.Date;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.version.PathResolver;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.shared.discussion.CommentAddedEvent;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.source.SourceGenerationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public abstract class KieService<T> {
    private static final Logger logger = LoggerFactory.getLogger(KieService.class);
    @Inject
    protected MetadataServerSideService metadataService;
    @Inject
    protected SourceServices sourceServices;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected Event<CommentAddedEvent> commentAddedEvent;
    @Inject
    protected User identity;
    @Inject
    protected SessionInfo sessionInfo;
    @Inject
    private PathResolver pathResolver;

    public T loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            if (this.pathResolver.isDotFile(Paths.convert((org.uberfire.backend.vfs.Path)path))) {
                return this.constructContent(Paths.convert((Path)this.pathResolver.resolveMainFilePath(Paths.convert((org.uberfire.backend.vfs.Path)path))), this.loadOverview(path));
            }
            return this.constructContent(path, this.loadOverview(path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected abstract T constructContent(org.uberfire.backend.vfs.Path var1, Overview var2);

    private Overview loadOverview(org.uberfire.backend.vfs.Path path) {
        Overview overview = new Overview();
        try {
            overview.setMetadata(this.metadataService.getMetadata(path));
        }
        catch (Exception e) {
            logger.warn("No metadata found for file: " + path.getFileName() + ", full path [" + path.toString() + "]");
        }
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project == null) {
            logger.info("File: " + path.getFileName() + ", full path [" + path.toString() + "] was not within a Project. Project Name cannot be set.");
        } else {
            overview.setProjectName(project.getProjectName());
        }
        return overview;
    }

    public String getSource(org.uberfire.backend.vfs.Path path) throws SourceGenerationFailedException {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.sourceServices.hasServiceFor(convertedPath)) {
            return this.sourceServices.getServiceFor(convertedPath).getSource(convertedPath);
        }
        return "";
    }

    protected CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getIdentifier();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }

    protected void fireMetadataSocialEvents(org.uberfire.backend.vfs.Path path, Metadata currentMetadata, Metadata newMetadata) {
        List currentDiscussion;
        List newDiscussion = newMetadata != null ? newMetadata.getDiscussion() : null;
        List list = currentDiscussion = currentMetadata != null ? currentMetadata.getDiscussion() : null;
        if (newDiscussion != null && newDiscussion.size() > 0) {
            for (DiscussionRecord newRecord : newDiscussion) {
                if (newRecord == null || currentDiscussion != null && currentDiscussion.contains(newRecord)) continue;
                this.commentAddedEvent.fire((Object)new CommentAddedEvent(newRecord.getAuthor(), path, newRecord.getNote(), newRecord.getTimestamp()));
            }
        }
    }
}

