/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.session;

import javax.inject.Inject;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.shared.project.KieProject;

public class SessionServiceImpl
implements SessionService {
    private LRUBuilderCache cache;

    public SessionServiceImpl() {
    }

    @Inject
    public SessionServiceImpl(LRUBuilderCache cache) {
        this.cache = cache;
    }

    public KieSession newKieSessionWithPseudoClock(KieProject project) {
        Builder builder = this.cache.assertBuilder((Project)project);
        try {
            KieContainer kieContainer = builder.getKieContainer();
            if (kieContainer == null) {
                return null;
            }
            SessionConfiguration conf = new SessionConfiguration();
            conf.setClockType(ClockType.PSEUDO_CLOCK);
            return kieContainer.getKieBase("defaultKieBase").newKieSession((KieSessionConfiguration)conf, null);
        }
        catch (RuntimeException e) {
            throw new GenericPortableException(e.getMessage());
        }
    }
}

