/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;

public class JndiRegistry
implements Registry {
    private Context context;

    public JndiRegistry() {
    }

    public JndiRegistry(Context context) {
        this.context = context;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object answer = this.lookupByName(name);
        if (answer == null) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in JNDI Context: " + this.context + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public Object lookupByName(String name) {
        try {
            return this.getContext().lookup(name);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap<String, T> answer = new LinkedHashMap<String, T>();
        try {
            NamingEnumeration<NameClassPair> list = this.getContext().list("");
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                Object instance = this.context.lookup(pair.getName());
                if (!type.isInstance(instance)) continue;
                answer.put(pair.getName(), type.cast(instance));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> answer = new LinkedHashSet<T>();
        try {
            NamingEnumeration<NameClassPair> list = this.getContext().list("");
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                Object instance = this.context.lookup(pair.getName());
                if (!type.isInstance(instance)) continue;
                answer.add(type.cast(instance));
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }

    public void bind(String name, Object object) {
        try {
            this.getContext().bind(name, object);
        }
        catch (NamingException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public void close() throws NamingException {
        if (this.context != null) {
            this.context.close();
        }
    }

    public Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    protected Context createContext() throws NamingException {
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>(System.getProperties());
        return new InitialContext(properties);
    }
}

