/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkProducer
implements Producer {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkProducer.class);
    private final Producer producer;
    private final AsyncProcessor processor;

    public UnitOfWorkProducer(Producer producer) {
        this.producer = producer;
        CamelInternalProcessor internal = new CamelInternalProcessor(producer);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
        this.processor = internal;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    @Override
    public void process(final Exchange exchange) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    LOG.trace("Asynchronous callback received for exchangeId: {}", (Object)exchange.getExchangeId());
                    latch.countDown();
                }
            }

            public String toString() {
                return "Done " + UnitOfWorkProducer.this.processor;
            }
        });
        if (!sync) {
            LOG.trace("Waiting for asynchronous callback before continuing for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            latch.await();
            LOG.trace("Asynchronous callback received, will continue routing exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public String toString() {
        return "UnitOfWork(" + this.producer + ")";
    }
}

