/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import org.apache.helix.healthcheck.AggregationType;
import org.apache.log4j.Logger;

public class WindowAggregationType
implements AggregationType {
    private static final Logger logger = Logger.getLogger(WindowAggregationType.class);
    public final String WINDOW_DELIM = "#";
    public static final String TYPE_NAME = "window";
    int _windowSize = 1;

    public WindowAggregationType(int ws) {
        this._windowSize = ws;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(TYPE_NAME);
        sb.append("#");
        sb.append(this._windowSize);
        return sb.toString();
    }

    @Override
    public String merge(String incomingVal, String existingVal, long prevTimestamp) {
        if (existingVal == null) {
            return incomingVal;
        }
        String[] windowVals = existingVal.split("#");
        int currLength = windowVals.length;
        if (currLength < this._windowSize) {
            return existingVal + "#" + incomingVal;
        }
        int firstDelim = existingVal.indexOf("#");
        return existingVal.substring(firstDelim + 1) + "#" + incomingVal;
    }
}

