/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access.security;

import java.security.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;

public class TcPermission
extends Permission {
    public static final String READWRITE = "readwrite";
    public static final String READ = "read";
    private String tcNamePattern;
    private boolean allowReadWrite = false;
    static final Pattern actionPattern = Pattern.compile(",( *)");

    public TcPermission(String tcNamePattern, String actions) {
        super(tcNamePattern);
        this.tcNamePattern = tcNamePattern;
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(actionPattern.split(actions)));
        if (actionSet.remove(READWRITE)) {
            this.allowReadWrite = true;
        } else if (!actionSet.contains(READ)) {
            throw new IllegalArgumentException("actions must be either \"read\" or \"readwrite\"");
        }
        actionSet.remove(READ);
        if (actionSet.size() > 0) {
            throw new IllegalArgumentException("actions must only contain \"read\" and \"readwrite\"");
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof TcPermission) {
            TcPermission other = (TcPermission)permission;
            if (!this.patternImplies(other.tcNamePattern)) {
                return false;
            }
            return this.actionsImplies(other.allowReadWrite);
        }
        return false;
    }

    private boolean actionsImplies(boolean readwriteOther) {
        if (!readwriteOther) {
            return true;
        }
        return this.allowReadWrite;
    }

    private boolean patternImplies(String tcNamePatternOther) {
        if (this.tcNamePattern.equals(tcNamePatternOther)) {
            return true;
        }
        if (this.tcNamePattern.endsWith("/*")) {
            return tcNamePatternOther.startsWith(this.tcNamePattern.substring(0, this.tcNamePattern.length() - 1));
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TcPermission other = (TcPermission)obj;
        if (!(this.tcNamePattern == other.tcNamePattern || this.tcNamePattern != null && this.tcNamePattern.equals(other.tcNamePattern))) {
            return false;
        }
        return this.allowReadWrite == other.allowReadWrite;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.tcNamePattern != null ? this.tcNamePattern.hashCode() : 0);
        if (this.allowReadWrite) {
            ++hash;
        }
        return hash;
    }

    @Override
    public String getActions() {
        return this.allowReadWrite ? READWRITE : READ;
    }
}

