/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.List;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;

public class OrganizationalUnitFactoryImpl
implements OrganizationalUnitFactory {
    @Inject
    private RepositoryService repositoryService;

    public OrganizationalUnit newOrganizationalUnit(ConfigGroup groupConfig) {
        ConfigItem roles;
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(groupConfig.getName(), groupConfig.getConfigItemValue("owner"), groupConfig.getConfigItemValue("defaultGroupId"));
        ConfigItem repositories = groupConfig.getConfigItem("repositories");
        if (repositories != null) {
            for (String alias : (List)repositories.getValue()) {
                Repository repo = this.repositoryService.getRepository(alias);
                if (repo == null) continue;
                organizationalUnit.getRepositories().add(repo);
            }
        }
        if ((roles = groupConfig.getConfigItem("security:roles")) != null) {
            for (String role : (List)roles.getValue()) {
                organizationalUnit.getRoles().add(role);
            }
        }
        return organizationalUnit;
    }
}

