/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.version.VersionUtil;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;

public class VersionLoader {
    private IOService ioService;
    private VersionUtil util;

    public VersionLoader() {
    }

    @Inject
    public VersionLoader(@Named(value="ioStrategy") IOService ioService, VersionUtil util) {
        this.ioService = ioService;
        this.util = util;
    }

    public List<VersionRecord> load(Path path) {
        List<VersionRecord> records = this.loadAllVersionRecords(path);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>();
        for (VersionRecord record : records) {
            if (!this.doesNotContainID(record.id(), result)) continue;
            result.add((VersionRecord)this.makePortable(record));
        }
        Collections.sort(result, new Comparator<VersionRecord>(){

            @Override
            public int compare(VersionRecord left, VersionRecord right) {
                return left.date().compareTo(right.date());
            }
        });
        return result;
    }

    private List<VersionRecord> loadAllVersionRecords(Path path) {
        ArrayList<VersionRecord> records = new ArrayList<VersionRecord>();
        records.addAll(this.loadVersionRecords(path));
        records.addAll(this.loadVersionRecords(this.util.getDotFilePath(path)));
        return records;
    }

    public List<VersionRecord> loadVersionRecords(Path path) {
        if (this.ioService.exists(path)) {
            return ((VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class)).readAttributes().history().records();
        }
        return Collections.EMPTY_LIST;
    }

    private PortableVersionRecord makePortable(VersionRecord record) {
        return new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri());
    }

    private boolean doesNotContainID(String id, List<VersionRecord> records) {
        for (VersionRecord record : records) {
            if (!record.id().equals(id)) continue;
            return false;
        }
        return true;
    }

    public VersionRecord loadRecord(Path path) throws URISyntaxException {
        for (VersionRecord record : this.loadVersionRecords(this.util.getPath(path, "master"))) {
            String version = this.util.getVersion(path);
            if ("master".equals(version)) {
                return record;
            }
            if (!record.id().equals(version)) continue;
            return record;
        }
        return null;
    }
}

