/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.version;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.file.Path;

class VersionUtil {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    VersionUtil() {
    }

    Path getDotFilePath(Path path) {
        return path.resolveSibling("." + path.getFileName());
    }

    String getVersion(Path path) {
        if (path instanceof AbstractPath) {
            String host = ((AbstractPath)path).getHost();
            return host.substring(0, host.indexOf("@"));
        }
        return "master";
    }

    Path getPath(Path path, String version) throws URISyntaxException {
        String authority = path.toUri().getAuthority();
        authority = version + authority.substring(authority.indexOf("@"));
        String scheme = path.getFileSystem().provider().getScheme();
        String rawPath = path.toUri().getRawPath();
        String uri = scheme + "://" + authority + rawPath;
        return this.ioService.get(new URI(uri));
    }

    String getFileName(Path path) {
        return path.getFileName().toString();
    }
}

