/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialUserCachePersistence;
import org.kie.uberfire.social.activities.persistence.SocialUserClusterMessaging;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class SocialUserClusterPersistence
extends SocialUserCachePersistence {
    private final SocialUserClusterMessaging socialUserClusterMessaging;

    public SocialUserClusterPersistence(SocialUserServicesExtendedBackEndImpl userServicesBackend, UserServicesImpl userServices, IOService ioService, Gson gson, SocialUserClusterMessaging socialUserClusterMessaging) {
        super(userServicesBackend, userServices, ioService, gson);
        this.socialUserClusterMessaging = socialUserClusterMessaging;
    }

    @Override
    public void updateUsers(SocialUser ... users) {
        for (SocialUser user : users) {
            this.usersCache.put(user.getUserName(), user);
            Path userFile = this.userServicesBackend.buildPath("social-files", user.getUserName());
            try {
                String json = this.gson.toJson((Object)user);
                this.ioService.write(userFile, json, new OpenOption[0]);
            }
            catch (Exception e) {
                throw new SocialUserCachePersistence.ErrorUpdatingUsers(e);
            }
            this.socialUserClusterMessaging.notify(user);
        }
    }

    @Override
    String syncUserNamesCacheAndFile(String userName) {
        if (this.usersNamesCache.contains(userName)) {
            return userName;
        }
        this.usersNamesCache.add(userName);
        SocialUser socialUser = this.createOrRetrieveUserData(userName);
        this.usersCache.put(userName, socialUser);
        this.writeUserNamesOnFile(this.usersNamesCache);
        return userName;
    }

    public void sync(SocialUser user) {
        if (!this.usersNamesCache.contains(user.getUserName())) {
            this.usersNamesCache.add(user.getUserName());
        }
        this.usersCache.put(user.getUserName(), user);
    }
}

