/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.base.ClassTypeResolver;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelerServiceHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.ProjectResourceDriverListener;
import org.kie.workbench.common.screens.datamodeller.backend.server.file.DataModelerCopyHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.file.DataModelerRenameHelper;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.EditorModelContent;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.screens.datamodeller.model.PropertyTypeTO;
import org.kie.workbench.common.screens.datamodeller.model.TypeInfoResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.datamodeller.service.ServiceException;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverError;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.driver.impl.DataModelOracleModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.JavaModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.JavaRoasterModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.ProjectDataModelOracleUtils;
import org.kie.workbench.common.services.datamodeller.parser.JavaFileHandler;
import org.kie.workbench.common.services.datamodeller.parser.JavaFileHandlerFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifiersContainerDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.VariableDeclarationDescr;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.FileHashingUtils;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;

@Service
@ApplicationScoped
public class DataModelerServiceImpl
extends KieService<EditorModelContent>
implements DataModelerService {
    private static final Logger logger = LoggerFactory.getLogger(DataModelerServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    private User identity;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private DataModelerServiceHelper serviceHelper;
    @Inject
    private ProjectResourceDriverListener generationListener;
    @Inject
    private Event<ResourceBatchChangesEvent> resourceBatchChangesEvent;
    @Inject
    private Event<DataObjectCreatedEvent> dataObjectCreatedEvent;
    @Inject
    private Event<DataObjectDeletedEvent> dataObjectDeletedEvent;
    @Inject
    private RefactoringQueryService queryService;
    @Inject
    private POMService pomService;
    @Inject
    private LRUBuilderCache builderCache;
    @Inject
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;
    @Inject
    private DeleteService deleteService;
    @Inject
    private CopyService copyService;
    @Inject
    private RenameService renameService;
    @Inject
    private DataModelerCopyHelper copyHelper;
    @Inject
    private DataModelerRenameHelper renameHelper;
    @Inject
    private GenericValidator genericValidator;
    private static final String DEFAULT_COMMIT_MESSAGE = "Data modeller generated action.";

    public EditorModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (EditorModelContent)super.loadContent(path);
    }

    public org.uberfire.backend.vfs.Path createJavaFile(org.uberfire.backend.vfs.Path context, String fileName, String comment) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
        org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
        if (this.ioService.exists(nioPath)) {
            throw new FileAlreadyExistsException(nioPath.toString());
        }
        try {
            Package currentPackage = this.projectService.resolvePackage(context);
            String packageName = currentPackage.getPackageName();
            String className = fileName.substring(0, fileName.indexOf(".java"));
            KieProject currentProject = (KieProject)this.projectService.resolveProject(context);
            DataObjectImpl dataObject = new DataObjectImpl(packageName, className);
            String source = this.createJavaSource((DataObject)dataObject);
            this.ioService.write(nioPath, source, new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
            DataObjectTO dataObjectTO = new DataObjectTO();
            this.serviceHelper.domain2To((DataObject)dataObject, dataObjectTO, DataModelTO.TOStatus.PERSISTENT);
            dataObjectTO.setPath(newPath);
            this.dataObjectCreatedEvent.fire((Object)new DataObjectCreatedEvent((Project)currentProject, dataObjectTO));
            return newPath;
        }
        catch (Exception e) {
            logger.error("It was not possible to create Java file, for path: " + context.toURI() + ", fileName: " + fileName, (Throwable)e);
            throw new ServiceException("It was not possible to create Java file, for path: " + context.toURI() + ", fileName: " + fileName, (Throwable)e);
        }
    }

    protected EditorModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading editor model from path: " + path.toURI());
        }
        Long startTime = System.currentTimeMillis();
        EditorModelContent editorModelContent = new EditorModelContent();
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                return editorModelContent;
            }
            Pair<DataModelTO, ModelDriverResult> resultPair = this.loadModel(project, false);
            DataModelTO dataModelTO = (DataModelTO)resultPair.getK1();
            String className = this.calculateClassName((Project)project, path);
            editorModelContent.setCurrentProject((Project)project);
            editorModelContent.setPath(path);
            editorModelContent.setCurrentProjectPackages(this.projectService.resolvePackages((Project)project));
            editorModelContent.setDataModel(dataModelTO);
            editorModelContent.setDataObject(dataModelTO.getDataObjectByClassName(className));
            editorModelContent.setOriginalClassName(className);
            editorModelContent.setOriginalPackageName(NamingUtils.extractPackageName((String)className));
            if (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path))) {
                String source = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
                editorModelContent.setSource(source);
            }
            if (((ModelDriverResult)resultPair.getK2()).hasErrors()) {
                editorModelContent.setErrors(this.serviceHelper.toDataModelerError(((ModelDriverResult)resultPair.getK2()).getErrors()));
            }
            editorModelContent.setOverview(overview);
            editorModelContent.setElapsedTime(System.currentTimeMillis() - startTime);
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when loading editor model from:" + path + " : " + editorModelContent.getElapsedTime() + " ms");
            }
            return editorModelContent;
        }
        catch (Exception e) {
            logger.error("Editor model couldn't be loaded from path: " + (path != null ? path.toURI() : path) + ".", (Throwable)e);
            throw new ServiceException("Editor model couldn't be loaded from path: " + (path != null ? path.toURI() : path) + ".", (Throwable)e);
        }
    }

    public DataModelTO loadModel(KieProject project) {
        Pair<DataModelTO, ModelDriverResult> resultPair = this.loadModel(project, true);
        return resultPair != null ? (DataModelTO)resultPair.getK1() : null;
    }

    private Pair<DataModelTO, ModelDriverResult> loadModel(KieProject project, boolean processErrors) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading data model from path: " + project.getRootPath());
        }
        Long startTime = System.currentTimeMillis();
        DataModel dataModel = null;
        org.uberfire.backend.vfs.Path projectPath = null;
        Package defaultPackage = null;
        try {
            projectPath = project.getRootPath();
            defaultPackage = this.projectService.resolveDefaultPackage((Project)project);
            if (logger.isDebugEnabled()) {
                logger.debug("Current project path is: " + projectPath);
            }
            ClassLoader classLoader = this.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath()), true, classLoader);
            ModelDriverResult result = modelDriver.loadModel();
            dataModel = result.getDataModel();
            if (processErrors && result.hasErrors()) {
                this.processErrors(project, result);
            }
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(projectPath);
            ProjectDataModelOracleUtils.loadExternalDependencies((DataModel)dataModel, (ProjectDataModelOracle)projectDataModelOracle, (ClassLoader)classLoader);
            DataModelTO dataModelTO = this.serviceHelper.domain2To(dataModel, result.getClassPaths(), result.getUnmanagedProperties(), DataModelTO.TOStatus.PERSISTENT, true);
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when loading " + projectPath.getFileName() + ": " + (endTime - startTime) + " ms");
            }
            return new Pair((Object)dataModelTO, (Object)result);
        }
        catch (Exception e) {
            logger.error("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
            throw new ServiceException("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
        }
    }

    public TypeInfoResult loadJavaTypeInfo(String source) {
        try {
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
            TypeInfoResult result = new TypeInfoResult();
            org.kie.workbench.common.services.datamodeller.driver.TypeInfoResult driverResult = modelDriver.loadJavaTypeInfo(source);
            result.setJavaTypeInfo(this.serviceHelper.domain2TO(driverResult.getTypeInfo()));
            if (driverResult.hasErrors()) {
                result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
            }
            return result;
        }
        catch (Exception e) {
            logger.error("JavaTypeInfo object couldn't be loaded for source: " + source, (Throwable)e);
            throw new ServiceException("JavaTypeInfo object couldn't be loaded for source.", (Throwable)e);
        }
    }

    private Pair<DataObjectTO, List<DataModelerError>> loadDataObject(org.uberfire.backend.vfs.Path projectPath, String source, org.uberfire.backend.vfs.Path sourcePath) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading data object from projectPath: " + projectPath.toURI());
        }
        DataObjectTO dataObjectTO = null;
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(projectPath);
            if (project == null) {
                return new Pair(null, new ArrayList());
            }
            ClassLoader classLoader = this.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, null, false, classLoader);
            ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)sourcePath));
            if (!driverResult.hasErrors()) {
                if (driverResult.getDataModel().getDataObjects().size() > 0) {
                    DataModelTO dataModelTO = this.serviceHelper.domain2To(driverResult.getDataModel(), driverResult.getClassPaths(), driverResult.getUnmanagedProperties(), DataModelTO.TOStatus.PERSISTENT, true);
                    dataObjectTO = (DataObjectTO)dataModelTO.getDataObjects().iterator().next();
                }
                return new Pair(dataObjectTO, new ArrayList());
            }
            return new Pair(null, this.serviceHelper.toDataModelerError(driverResult.getErrors()));
        }
        catch (Exception e) {
            logger.error("Data object couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
            throw new ServiceException("Data object couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
        }
    }

    private Pair<DataObjectTO, List<DataModelerError>> loadDataObject(org.uberfire.backend.vfs.Path path) {
        return this.loadDataObject(path, this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path)), path);
    }

    public GenerationResult updateSource(String source, org.uberfire.backend.vfs.Path path, DataObjectTO dataObjectTO) {
        GenerationResult result = new GenerationResult();
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            ClassLoader classLoader = this.getProjectClassLoader(project);
            Pair<String, List<DataModelerError>> updateResult = this.updateJavaSource(source, dataObjectTO, new HashMap<String, String>(), new ArrayList<String>(), classLoader);
            result.setSource((String)updateResult.getK1());
            result.setDataObject(dataObjectTO);
            result.setErrors((List)updateResult.getK2());
            return result;
        }
        catch (Exception e) {
            logger.error("Source file for data object: " + dataObjectTO.getClassName() + ", couldn't be updated", (Throwable)e);
            throw new ServiceException("Source file for data object: " + dataObjectTO.getClassName() + ", couldn't be updated", (Throwable)e);
        }
    }

    public GenerationResult updateDataObject(DataObjectTO dataObjectTO, String source, org.uberfire.backend.vfs.Path path) {
        GenerationResult result = new GenerationResult();
        try {
            result.setSource(source);
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            ClassLoader classLoader = this.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)path), false, classLoader);
            ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)path));
            if (driverResult.hasErrors()) {
                result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
            } else if (driverResult.getDataModel().getDataObjects().size() > 0) {
                DataModelTO dataModelTO = this.serviceHelper.domain2To(driverResult.getDataModel(), driverResult.getClassPaths(), driverResult.getUnmanagedProperties(), DataModelTO.TOStatus.PERSISTENT, true);
                result.setDataObject((DataObjectTO)dataModelTO.getDataObjects().iterator().next());
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Source file for data object: " + dataObjectTO.getClassName() + ", couldn't be parsed", (Throwable)e);
            throw new ServiceException("Source file for data object: " + dataObjectTO.getClassName() + ", couldn't be parsed", (Throwable)e);
        }
    }

    public GenerationResult saveSource(String source, org.uberfire.backend.vfs.Path path, DataObjectTO dataObjectTO, Metadata metadata, String commitMessage) {
        return this.saveSource(source, path, dataObjectTO, metadata, commitMessage, null, null);
    }

    public GenerationResult saveSource(String source, org.uberfire.backend.vfs.Path path, DataObjectTO dataObjectTO, Metadata metadata, String commitMessage, String newPackageName, String newFileName) {
        Boolean onBatch = false;
        try {
            Package currentPackage;
            GenerationResult result = this.resolveSaveSource(source, path, dataObjectTO);
            Package targetPackage = currentPackage = this.projectService.resolvePackage(path);
            String targetName = path.getFileName();
            Path targetPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            boolean packageChanged = false;
            boolean nameChanged = false;
            if (!(newPackageName == null || currentPackage != null && newPackageName.equals(currentPackage.getPackageName()))) {
                targetPackage = this.serviceHelper.ensurePackageStructure(this.projectService.resolveProject(path), newPackageName);
                packageChanged = true;
            }
            if (newFileName != null && !(newFileName + ".java").equals(path.getFileName())) {
                targetName = newFileName + ".java";
                nameChanged = true;
            }
            this.fireMetadataSocialEvents(path, this.metadataService.getMetadata(path), metadata);
            if (packageChanged) {
                targetPath = Paths.convert((org.uberfire.backend.vfs.Path)targetPackage.getPackageMainSrcPath()).resolve(targetName);
                this.ioService.startBatch(targetPath.getFileSystem());
                onBatch = true;
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                this.ioService.move(Paths.convert((org.uberfire.backend.vfs.Path)path), targetPath, new CopyOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                result.setPath(Paths.convert((Path)targetPath));
            } else if (nameChanged) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                org.uberfire.backend.vfs.Path newPath = this.renameService.rename(path, newFileName, commitMessage);
                result.setPath(newPath);
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                result.setPath(path);
            }
            GenerationResult generationResult = result;
            return generationResult;
        }
        catch (Exception e) {
            logger.error("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObjectTO != null ? dataObjectTO.getClassName() : null) + ".", (Throwable)e);
            throw new ServiceException("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObjectTO != null ? dataObjectTO.getClassName() : null) + ".", (Throwable)e);
        }
        finally {
            if (onBatch.booleanValue()) {
                this.ioService.endBatch();
            }
        }
    }

    private GenerationResult resolveSaveSource(String source, org.uberfire.backend.vfs.Path path, DataObjectTO dataObjectTO) {
        GenerationResult result = new GenerationResult();
        try {
            String updatedSource;
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            if (dataObjectTO != null) {
                result = this.updateSource(source, path, dataObjectTO);
                updatedSource = result.getSource();
            } else {
                updatedSource = source;
            }
            if (dataObjectTO == null) {
                ClassLoader classLoader = this.getProjectClassLoader(project);
                JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)path), false, classLoader);
                ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)path));
                if (driverResult.hasErrors()) {
                    result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
                } else if (driverResult.getDataModel().getDataObjects().size() > 0) {
                    DataModelTO dataModelTO = this.serviceHelper.domain2To(driverResult.getDataModel(), driverResult.getClassPaths(), driverResult.getUnmanagedProperties(), DataModelTO.TOStatus.PERSISTENT, true);
                    result.setDataObject((DataObjectTO)dataModelTO.getDataObjects().iterator().next());
                }
            }
            result.setSource(updatedSource);
            return result;
        }
        catch (Exception e) {
            logger.error("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObjectTO != null ? dataObjectTO.getClassName() : null) + ".", (Throwable)e);
            throw new ServiceException("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObjectTO != null ? dataObjectTO.getClassName() : null) + ".", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment, boolean refactor) {
        org.uberfire.backend.vfs.Path targetPath = null;
        if (refactor) {
            try {
                GenerationResult refactoringResult = this.refactorClass(path, null, newName);
                if (!refactoringResult.hasErrors()) {
                    targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).resolveSibling(newName + ".java"));
                    this.copyHelper.addRefactoredPath(targetPath, refactoringResult.getSource(), comment);
                    KieProject project = (KieProject)this.projectService.resolveProject(targetPath);
                    if (project != null) {
                        this.dataObjectCreatedEvent.fire((Object)new DataObjectCreatedEvent((Project)project, refactoringResult.getDataObject()));
                    }
                }
            }
            catch (Exception e) {
                logger.error("An error was produced during class refactoring at file copying for file: " + path + ". The file copying will continue without class refactoring", (Throwable)e);
            }
        }
        try {
            org.uberfire.backend.vfs.Path path2 = this.copyService.copy(path, newName, comment);
            return path2;
        }
        finally {
            if (targetPath != null) {
                this.copyHelper.removeRefactoredPath(targetPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment, boolean refactor, boolean saveCurrentChanges, String source, DataObjectTO dataObjectTO, Metadata metadata) {
        String sourceToRefactor;
        GenerationResult saveResult = null;
        if (saveCurrentChanges) {
            saveResult = this.resolveSaveSource(source, path, dataObjectTO);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), saveResult.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
        }
        org.uberfire.backend.vfs.Path targetPath = null;
        String newContent = null;
        if (refactor && (sourceToRefactor = saveCurrentChanges ? (saveResult != null && !saveResult.hasErrors() ? saveResult.getSource() : null) : source) != null) {
            try {
                GenerationResult refactoringResult = this.refactorClass(sourceToRefactor, path, null, newName);
                if (!refactoringResult.hasErrors()) {
                    targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).resolveSibling(newName + ".java"));
                    this.renameHelper.addRefactoredPath(targetPath, refactoringResult.getSource(), comment);
                    newContent = refactoringResult.getSource();
                }
            }
            catch (Exception e) {
                logger.error("An error was produced during class refactoring at file renaming for file: " + path + ". The file renaming will continue without class refactoring", (Throwable)e);
            }
        }
        try {
            org.uberfire.backend.vfs.Path path2;
            boolean workaround = true;
            if (!workaround) {
                path2 = this.renameService.rename(path, newName, comment);
                return path2;
            }
            path2 = this.renameWorkaround(path, newName, newContent, comment);
            return path2;
        }
        finally {
            if (targetPath != null) {
                this.renameHelper.removeRefactoredPath(targetPath);
            }
        }
    }

    public org.uberfire.backend.vfs.Path renameWorkaround(org.uberfire.backend.vfs.Path path, String newName, String newContent, String comment) {
        try {
            Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String originalFileName = _path.getFileName().toString();
            String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
            Path _target = _path.resolveSibling(newName + extension);
            org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
            try {
                if (newContent != null) {
                    this.ioService.write(_path, newContent, new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
                }
                this.ioService.startBatch(new FileSystem[]{_target.getFileSystem()});
                this.ioService.move(_path, _target, new CopyOption[]{this.serviceHelper.makeCommentedOption("File [" + path.toURI() + "] renamed to [" + targetPath.toURI() + "].")});
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            return Paths.convert((Path)_target);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String getSource(org.uberfire.backend.vfs.Path path) {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return this.ioService.readAllString(convertedPath);
    }

    private void processErrors(KieProject project, ModelDriverResult result) {
        PublishBatchMessagesEvent publishEvent = new PublishBatchMessagesEvent();
        publishEvent.setCleanExisting(true);
        publishEvent.setUserId(this.identity != null ? this.identity.getIdentifier() : null);
        publishEvent.setMessageType("DataModeler");
        for (ModelDriverError error : result.getErrors()) {
            SystemMessage systemMessage = new SystemMessage();
            systemMessage.setMessageType("DataModeler");
            systemMessage.setLevel(SystemMessage.Level.ERROR);
            systemMessage.setId(error.getId());
            systemMessage.setText(error.getMessage());
            systemMessage.setColumn(error.getColumn());
            systemMessage.setLine(error.getLine());
            systemMessage.setPath(Paths.convert((Path)error.getFile()));
            publishEvent.getMessagesToPublish().add(systemMessage);
        }
        this.publishBatchMessagesEvent.fire((Object)publishEvent);
    }

    public GenerationResult saveModel(DataModelTO dataModel, KieProject project, boolean overwrite, String commitMessage) {
        Long startTime = System.currentTimeMillis();
        boolean onBatch = false;
        try {
            CommentedOption option = this.serviceHelper.makeCommentedOption(commitMessage);
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()).getFileSystem());
            onBatch = true;
            this.generateModel(dataModel, project, option);
            onBatch = false;
            this.ioService.endBatch();
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when saving " + project.getProjectName() + ": " + (endTime - startTime) + " ms");
            }
            GenerationResult result = new GenerationResult();
            result.setGenerationTime(endTime - startTime);
            result.setObjectFingerPrints(this.serviceHelper.claculateFingerPrints(dataModel));
            return result;
        }
        catch (Exception e) {
            logger.error("An error was produced during data model generation, dataModel: " + dataModel + ", path: " + project.getRootPath(), (Throwable)e);
            if (onBatch) {
                try {
                    logger.warn("IOService batch method is still on, trying to end batch processing.");
                    this.ioService.endBatch();
                    logger.warn("IOService batch method is was successfully finished. The user will still get the exception, but the batch processing was finished.");
                }
                catch (Exception ex) {
                    logger.error("An error was produced when the IOService.endBatch processing was executed.", (Throwable)ex);
                }
            }
            throw new ServiceException("Data model: " + dataModel.getParentProjectName() + ", couldn't be generated due to the following error. " + e);
        }
    }

    public GenerationResult saveModel(DataModelTO dataModel, KieProject project) {
        return this.saveModel(dataModel, project, false, DEFAULT_COMMIT_MESSAGE);
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                return;
            }
            this.deleteService.delete(path, comment);
            String className = this.calculateClassName((Project)project, path);
            DataObjectTO dataObjectTO = new DataObjectTO(NamingUtils.extractClassName((String)className), NamingUtils.extractPackageName((String)className), null);
            this.dataObjectDeletedEvent.fire((Object)new DataObjectDeletedEvent((Project)project, dataObjectTO));
        }
        catch (Exception e) {
            logger.error("File: " + path.toURI() + " couldn't be deleted due to the following error. ", (Throwable)e);
            throw new ServiceException("File: " + path.toURI() + " couldn't be deleted due to the following error. " + e.getMessage());
        }
    }

    public GenerationResult refactorClass(org.uberfire.backend.vfs.Path path, String newPackageName, String newClassName) {
        String source = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
        return this.refactorClass(source, path, newPackageName, newClassName);
    }

    private GenerationResult refactorClass(String source, org.uberfire.backend.vfs.Path path, String newPackageName, String newClassName) {
        Pair<DataObjectTO, List<DataModelerError>> result = this.loadDataObject(path, source, path);
        if ((result.getK2() == null || ((List)result.getK2()).isEmpty()) && result.getK1() != null) {
            DataObjectTO dataObjectTO = (DataObjectTO)result.getK1();
            if (newPackageName != null) {
                dataObjectTO.setPackageName(newPackageName);
            }
            if (newClassName != null) {
                dataObjectTO.setName(newClassName);
            }
            return this.updateSource(source, path, dataObjectTO);
        }
        return new GenerationResult(null, null, (List)result.getK2());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ValidationMessage> validate(String source, org.uberfire.backend.vfs.Path path, DataObjectTO dataObjectTO) {
        try {
            String validationSource = null;
            ArrayList<ValidationMessage> validations = new ArrayList<ValidationMessage>();
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                ValidationMessage validationMessage = new ValidationMessage();
                validationMessage.setPath(path);
                validationMessage.setText("File do no belong to a valid project");
                validationMessage.setLevel(ValidationMessage.Level.ERROR);
                validations.add(new ValidationMessage());
                return validations;
            }
            if (dataObjectTO != null) {
                GenerationResult result = this.updateSource(source, path, dataObjectTO);
                if (result.hasErrors()) return this.serviceHelper.toValidationMessage(result.getErrors());
                validationSource = result.getSource();
                return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(validationSource != null ? validationSource.getBytes(Charsets.UTF_8) : "".getBytes()), new DirectoryStream.Filter[]{new JavaFileFilter()});
            } else {
                validationSource = source;
            }
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(validationSource != null ? validationSource.getBytes(Charsets.UTF_8) : "".getBytes()), new DirectoryStream.Filter[]{new JavaFileFilter()});
        }
        catch (Exception e) {
            logger.error("An error was produced during validation", (Throwable)e);
            throw new ServiceException("An error was produced during validation", (Throwable)e);
        }
    }

    private void generateModel(DataModelTO dataModelTO, KieProject project, CommentedOption option) throws Exception {
        Map<String, String> renames = this.serviceHelper.calculatePersistentDataObjectRenames(dataModelTO);
        List<String> deletions = this.serviceHelper.calculatePersistentDataObjectDeletions(dataModelTO);
        ClassLoader classLoader = this.getProjectClassLoader(project);
        org.uberfire.backend.vfs.Path projectPath = project.getRootPath();
        Path javaRootPath = this.ensureProjectJavaPath(Paths.convert((org.uberfire.backend.vfs.Path)projectPath));
        for (DataObjectTO dataObjectTO : dataModelTO.getDeletedDataObjects()) {
            if (!dataObjectTO.isPersistent()) continue;
            Path deletedObjectFile = this.calculateFilePath(dataObjectTO.getOriginalClassName(), javaRootPath);
            if (logger.isDebugEnabled()) {
                logger.debug("Data object: " + dataObjectTO.getClassName() + " was deleted in the UI, associated .java file should be deleted.");
                logger.debug("current class name is: " + dataObjectTO.getClassName());
                logger.debug("original class name is: " + dataObjectTO.getOriginalClassName());
                logger.debug("file to be deleted is: " + deletedObjectFile);
            }
            this.ioService.deleteIfExists(deletedObjectFile, new DeleteOption[]{option});
        }
        for (DataObjectTO dataObjectTO : dataModelTO.getDataObjects()) {
            String newSource;
            Path targetFile;
            if (dataObjectTO.isVolatile()) {
                targetFile = this.calculateFilePath(dataObjectTO.getClassName(), javaRootPath);
                if (logger.isDebugEnabled()) {
                    logger.debug("Data object: " + dataObjectTO.getClassName() + " is a new object created in the UI, java source code will be generated from scratch and written into file: " + targetFile);
                }
                newSource = this.createJavaSource(this.serviceHelper.to2Domain(dataObjectTO));
                this.ioService.write(targetFile, newSource, new OpenOption[]{option});
                continue;
            }
            if (this.hasUIChanges(dataObjectTO)) {
                Path sourceFile;
                if (logger.isDebugEnabled()) {
                    logger.debug("Data object: " + dataObjectTO.getClassName() + " needs to be updated with UI changes.");
                }
                if (dataObjectTO.classNameChanged()) {
                    sourceFile = this.calculateFilePath(dataObjectTO.getOriginalClassName(), javaRootPath);
                    targetFile = this.calculateFilePath(dataObjectTO.getClassName(), javaRootPath);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Data object was renamed form class name: " + dataObjectTO.getOriginalClassName() + " to: " + dataObjectTO.getClassName());
                    }
                } else {
                    targetFile = sourceFile = this.calculateFilePath(dataObjectTO.getClassName(), javaRootPath);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("original content will be read from file: " + sourceFile);
                    logger.debug("updated content will be written into file: " + targetFile);
                }
                if (this.ioService.exists(sourceFile)) {
                    newSource = (String)this.updateJavaSource(sourceFile, dataObjectTO, renames, deletions, classLoader).getK1();
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("original content file: " + sourceFile + ", seems to not exists. Java source code will be generated from scratch.");
                    }
                    newSource = this.createJavaSource(this.serviceHelper.to2Domain(dataObjectTO));
                }
                this.ioService.write(targetFile, newSource, new OpenOption[]{option});
                if (sourceFile.equals(targetFile)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("original content file: " + sourceFile + " needs to be deleted.");
                }
                this.ioService.deleteIfExists(sourceFile, new DeleteOption[0]);
                continue;
            }
            logger.debug("Data object: " + dataObjectTO.getClassName() + " wasn't changed in the UI, NO file update is needed.");
        }
    }

    private Pair<String, List<DataModelerError>> updateJavaSource(String originalSource, DataObjectTO dataObjectTO, Map<String, String> renames, List<String> deletions, ClassLoader classLoader) throws Exception {
        String newSource;
        JavaType javaType;
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting java source update for class: " + dataObjectTO.getClassName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("original source is: " + originalSource);
        }
        if ((javaType = Roaster.parse((String)originalSource)).isClass()) {
            if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                errors.addAll(this.serviceHelper.toDataModelerError(javaType.getSyntaxErrors(), null));
                newSource = originalSource;
            } else {
                JavaClassSource javaClassSource = (JavaClassSource)javaType;
                ClassTypeResolver classTypeResolver = DriverUtils.getInstance().createClassTypeResolver(javaClassSource, classLoader);
                this.updateJavaClassSource(dataObjectTO, javaClassSource, renames, deletions, classTypeResolver);
                newSource = javaClassSource.toString();
            }
        } else {
            logger.debug("No Class definition was found for source: " + originalSource + ", original source won't be modified.");
            newSource = originalSource;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updated source is: " + newSource);
        }
        return new Pair((Object)newSource, errors);
    }

    private Pair<String, List<DataModelerError>> updateJavaSource(Path path, DataObjectTO dataObjectTO, Map<String, String> renames, List<String> deletions, ClassLoader classLoader) throws Exception {
        String originalSource = this.ioService.readAllString(path);
        if (logger.isDebugEnabled()) {
            logger.debug("path is: " + path);
        }
        return this.updateJavaSource(originalSource, dataObjectTO, renames, deletions, classLoader);
    }

    private void updateJavaClassSource(DataObjectTO dataObjectTO, JavaClassSource javaClassSource, Map<String, String> renames, List<String> deletions, ClassTypeResolver classTypeResolver) throws Exception {
        if (javaClassSource == null || !javaClassSource.isClass()) {
            logger.warn("A null javaClassSource or javaClassSouce is not a Class, no processing will be done. javaClassSource: " + javaClassSource + " className: " + (javaClassSource != null ? javaClassSource.getName() : null));
            return;
        }
        HashMap<String, FieldSource> currentClassFields = new HashMap<String, FieldSource>();
        List classFields = javaClassSource.getFields();
        HashMap<String, String> preservedFields = new HashMap<String, String>();
        DataObject dataObject = this.serviceHelper.to2Domain(dataObjectTO);
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        modelDriver.updatePackage(javaClassSource, dataObjectTO.getPackageName());
        modelDriver.updateImports(javaClassSource, renames, deletions);
        modelDriver.updateAnnotations((AnnotationTargetSource)javaClassSource, dataObject.getAnnotations(), classTypeResolver);
        modelDriver.updateClassName(javaClassSource, dataObjectTO.getName());
        modelDriver.updateSuperClassName(javaClassSource, dataObjectTO.getSuperClassName(), classTypeResolver);
        if (classFields != null) {
            for (FieldSource field : classFields) {
                currentClassFields.put(field.getName(), field);
            }
        }
        List currentManagedProperties = modelDriver.parseManagedTypesProperties(javaClassSource, classTypeResolver);
        currentManagedProperties = DataModelUtils.filterAssignableFields((List)currentManagedProperties);
        List allFieldsConstructorCandidates = modelDriver.findAllFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        List keyFieldsConstructorCandidates = modelDriver.findKeyFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        List positionFieldsConstructorCandidates = modelDriver.findPositionFieldsConstructorCandidates(javaClassSource, currentManagedProperties, classTypeResolver);
        for (ObjectPropertyTO propertyTO : dataObjectTO.getProperties()) {
            ObjectProperty property = this.serviceHelper.to2Domain(propertyTO);
            if (property.isFinal() || property.isStatic()) {
                preservedFields.put(property.getName(), property.getName());
                continue;
            }
            if (propertyTO.isVolatile()) {
                if (currentClassFields.containsKey(propertyTO.getName())) {
                    modelDriver.removeField(javaClassSource, propertyTO.getName(), classTypeResolver);
                }
                modelDriver.createField(javaClassSource, property, classTypeResolver);
                preservedFields.put(property.getName(), property.getName());
                continue;
            }
            if (propertyTO.nameChanged()) {
                if (currentClassFields.containsKey(propertyTO.getOriginalName())) {
                    modelDriver.updateField(javaClassSource, propertyTO.getOriginalName(), property, classTypeResolver);
                    preservedFields.put(propertyTO.getName(), propertyTO.getName());
                    continue;
                }
                if (currentClassFields.containsKey(propertyTO.getName())) {
                    modelDriver.removeField(javaClassSource, propertyTO.getName(), classTypeResolver);
                }
                modelDriver.createField(javaClassSource, property, classTypeResolver);
                preservedFields.put(property.getName(), property.getName());
                continue;
            }
            if (currentClassFields.containsKey(propertyTO.getName())) {
                modelDriver.updateField(javaClassSource, propertyTO.getName(), property, classTypeResolver);
            } else {
                modelDriver.createField(javaClassSource, property, classTypeResolver);
            }
            preservedFields.put(property.getName(), property.getName());
        }
        modelDriver.updateConstructors(javaClassSource, dataObject, allFieldsConstructorCandidates, keyFieldsConstructorCandidates, positionFieldsConstructorCandidates, classTypeResolver);
        ArrayList<String> removableFields = new ArrayList<String>();
        for (FieldSource field : currentClassFields.values()) {
            if (preservedFields.containsKey(field.getName()) || !modelDriver.isManagedField(field, classTypeResolver)) continue;
            removableFields.add(field.getName());
        }
        for (String fieldName : removableFields) {
            modelDriver.removeField(javaClassSource, fieldName, classTypeResolver);
        }
    }

    private String createJavaSource(DataObject dataObject) throws Exception {
        String source;
        GenerationContext generationContext = new GenerationContext(null);
        try {
            GenerationEngine engine = GenerationEngine.getInstance();
            source = engine.generateJavaClassString(generationContext, dataObject);
        }
        catch (Exception e) {
            logger.error("Java source for dataObject: " + dataObject.getClassName() + " couldn't be created.", (Throwable)e);
            throw e;
        }
        return source;
    }

    private ClassLoader getProjectClassLoader(KieProject project) {
        KieModule module = this.builderCache.assertBuilder((Project)project).getKieModuleIgnoringErrors();
        ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
        return classLoader;
    }

    public Boolean verifiesHash(org.uberfire.backend.vfs.Path javaFile) {
        if (javaFile == null) {
            return false;
        }
        Path filePath = Paths.convert((org.uberfire.backend.vfs.Path)javaFile);
        String content = this.ioService.readAllString(filePath);
        String string = content = content != null ? content.trim() : null;
        if (content == null) {
            return false;
        }
        String expectedHashValue = FileHashingUtils.extractFileHashValue((String)content);
        if (expectedHashValue != null) {
            return FileHashingUtils.verifiesHash((String)content, (String)expectedHashValue);
        }
        return false;
    }

    public List<org.uberfire.backend.vfs.Path> findClassUsages(org.uberfire.backend.vfs.Path currentPath, String className) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add((ValueIndexTerm)new ValueTypeIndexTerm(className));
        return this.executeReferencesQuery(currentPath, "FindTypesQuery", queryTerms);
    }

    public List<org.uberfire.backend.vfs.Path> findFieldUsages(org.uberfire.backend.vfs.Path currentPath, String className, String fieldName) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add((ValueIndexTerm)new ValueTypeIndexTerm(className));
        queryTerms.add((ValueIndexTerm)new ValueFieldIndexTerm(fieldName));
        return this.executeReferencesQuery(currentPath, "FindTypeFieldsQuery", queryTerms);
    }

    private List<org.uberfire.backend.vfs.Path> executeReferencesQuery(org.uberfire.backend.vfs.Path currentPath, String queryName, HashSet<ValueIndexTerm> queryTerms) {
        ArrayList<org.uberfire.backend.vfs.Path> results = new ArrayList<org.uberfire.backend.vfs.Path>();
        RefactoringPageRequest request = new RefactoringPageRequest(queryName, queryTerms, 0, Integer.valueOf(100));
        try {
            PageResponse response = this.queryService.query(request);
            if (response != null && response.getPageRowList() != null) {
                for (RefactoringPageRow row : response.getPageRowList()) {
                    results.add((org.uberfire.backend.vfs.Path)row.getValue());
                }
            }
            return this.filterResults(currentPath, results);
        }
        catch (Exception e) {
            logger.error("References query: " + queryName + ", couldn't be executed: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("References query: " + queryName + ", couldn't be executed: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<org.uberfire.backend.vfs.Path> filterResults(org.uberfire.backend.vfs.Path currentPath, List<org.uberfire.backend.vfs.Path> results) {
        if (currentPath == null) {
            return results;
        }
        KieProject project = (KieProject)this.projectService.resolveProject(currentPath);
        if (project == null) {
            return results;
        }
        org.uberfire.backend.vfs.Path rootPath = project.getRootPath();
        if (rootPath == null) {
            return results;
        }
        ArrayList<org.uberfire.backend.vfs.Path> filteredResults = new ArrayList<org.uberfire.backend.vfs.Path>();
        String projectURI = rootPath.toURI();
        if (results != null) {
            for (org.uberfire.backend.vfs.Path result : results) {
                if (!result.toURI().startsWith(projectURI)) continue;
                filteredResults.add(result);
            }
        }
        return filteredResults;
    }

    public List<PropertyTypeTO> getBasePropertyTypes() {
        ArrayList<PropertyTypeTO> types = new ArrayList<PropertyTypeTO>();
        for (PropertyType baseType : PropertyTypeFactoryImpl.getInstance().getBasePropertyTypes()) {
            types.add(new PropertyTypeTO(baseType.getName(), baseType.getClassName(), baseType.isPrimitive()));
        }
        return types;
    }

    public Map<String, AnnotationDefinitionTO> getAnnotationDefinitions() {
        HashMap<String, AnnotationDefinitionTO> annotations = new HashMap<String, AnnotationDefinitionTO>();
        List annotationDefinitions = DataModelOracleModelDriver.getInstance().getConfiguredAnnotations();
        for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
            AnnotationDefinitionTO annotationDefinitionTO = this.serviceHelper.domain2To(annotationDefinition);
            annotations.put(annotationDefinitionTO.getClassName(), annotationDefinitionTO);
        }
        return annotations;
    }

    public Boolean exists(org.uberfire.backend.vfs.Path path) {
        return this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path));
    }

    public Set<Package> resolvePackages(org.uberfire.backend.vfs.Path path) {
        Project project = null;
        if (path != null) {
            project = this.projectService.resolveProject(path);
        }
        if (path == null || project == null) {
            return new HashSet<Package>();
        }
        return this.projectService.resolvePackages(project);
    }

    private boolean hasUIChanges(DataObjectTO dataObjectTO) {
        boolean result;
        String newFingerPrint = this.serviceHelper.calculateFingerPrint(dataObjectTO.getStringId());
        boolean bl = result = !newFingerPrint.equals(dataObjectTO.getFingerPrint());
        if (!result) {
            logger.debug("The class : " + dataObjectTO.getClassName() + " wasn't modified");
        }
        return result;
    }

    private void cleanupEmptyDirs(Path pojectPath) {
        FileUtils fileUtils = FileUtils.getInstance();
        ArrayList<String> deleteableFiles = new ArrayList<String>();
        deleteableFiles.add(".gitignore");
        fileUtils.cleanEmptyDirectories(this.ioService, pojectPath, false, deleteableFiles);
    }

    private Path existsProjectJavaPath(Path projectPath) {
        Path javaPath = projectPath.resolve("src").resolve("main").resolve("java");
        if (this.ioService.exists(javaPath)) {
            return javaPath;
        }
        return null;
    }

    private Path ensureProjectJavaPath(Path projectPath) {
        Path javaPath = projectPath.resolve("src");
        if (!this.ioService.exists(javaPath)) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("main"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("java"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        return javaPath;
    }

    private String calculateClassName(Project project, org.uberfire.backend.vfs.Path path) {
        org.uberfire.backend.vfs.Path rootPath = project.getRootPath();
        if (!path.toURI().startsWith(rootPath.toURI())) {
            return null;
        }
        Package defaultPackage = this.projectService.resolveDefaultPackage(project);
        org.uberfire.backend.vfs.Path srcPath = null;
        if (path.toURI().startsWith(defaultPackage.getPackageMainSrcPath().toURI())) {
            srcPath = defaultPackage.getPackageMainSrcPath();
        } else if (path.toURI().startsWith(defaultPackage.getPackageTestSrcPath().toURI())) {
            srcPath = defaultPackage.getPackageTestSrcPath();
        }
        if (srcPath == null) {
            return null;
        }
        String strPath = path.toURI().substring(srcPath.toURI().length() + 1, path.toURI().length());
        strPath = strPath.replace("/", ".");
        strPath = strPath.substring(0, strPath.indexOf(".java"));
        return strPath;
    }

    private Path calculateFilePath(String className, Path javaPath) {
        String name = NamingUtils.extractClassName((String)className);
        String packageName = NamingUtils.extractPackageName((String)className);
        Path filePath = javaPath;
        if (packageName != null) {
            List packageNameTokens = NamingUtils.tokenizePackageName((String)packageName);
            for (String token : packageNameTokens) {
                filePath = filePath.resolve(token);
            }
        }
        filePath = filePath.resolve(name + ".java");
        return filePath;
    }

    private String updateJavaSourceAntlr(DataObjectTO dataObjectTO, Path path, ClassLoader classLoader) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting java source update for class: " + dataObjectTO.getClassName() + ", and path: " + path);
        }
        String originalSource = this.ioService.readAllString(path);
        if (logger.isDebugEnabled()) {
            logger.debug("original source is: " + originalSource);
        }
        JavaFileHandler fileHandler = JavaFileHandlerFactory.getInstance().newHandler(originalSource);
        ClassTypeResolver classTypeResolver = DriverUtils.getInstance().createClassTypeResolver(fileHandler.getFileDescr(), classLoader);
        this.updateJavaFileDescrAntlr(dataObjectTO, fileHandler.getFileDescr(), classTypeResolver);
        String newSource = fileHandler.buildResult();
        if (logger.isDebugEnabled()) {
            logger.debug("updated source is: " + newSource);
        }
        return newSource;
    }

    private void updateJavaFileDescrAntlr(DataObjectTO dataObjectTO, FileDescr fileDescr, ClassTypeResolver classTypeResolver) throws Exception {
        if (fileDescr == null || fileDescr.getClassDescr() == null) {
            logger.warn("A null FileDescr or ClassDescr was provided, no processing will be done. fileDescr: " + fileDescr + " classDescr: " + (fileDescr != null ? fileDescr.getClassDescr() : null));
            return;
        }
        ClassDescr classDescr = fileDescr.getClassDescr();
        HashMap<String, FieldDescr> currentFields = new HashMap<String, FieldDescr>();
        HashMap<String, String> preservedFields = new HashMap<String, String>();
        DataObject dataObject = this.serviceHelper.to2Domain(dataObjectTO);
        JavaModelDriver modelDriver = new JavaModelDriver();
        modelDriver.updatePackage(fileDescr, dataObjectTO.getPackageName());
        modelDriver.updateClassOrFieldAnnotations((ElementDescriptor)fileDescr, (ModifiersContainerDescr)classDescr, dataObject.getAnnotations(), classTypeResolver);
        modelDriver.updateClassName(classDescr, dataObjectTO.getName());
        modelDriver.updateSuperClassName(classDescr, dataObjectTO.getSuperClassName(), classTypeResolver);
        for (FieldDescr fieldDescr : classDescr.getFields()) {
            for (VariableDeclarationDescr variableDescr : fieldDescr.getVariableDeclarations()) {
                currentFields.put(variableDescr.getIdentifier().getIdentifier(), fieldDescr);
            }
        }
        for (ObjectPropertyTO propertyTO : dataObjectTO.getProperties()) {
            ObjectProperty property = this.serviceHelper.to2Domain(propertyTO);
            if (propertyTO.isVolatile()) {
                if (currentFields.containsKey(propertyTO.getName())) {
                    modelDriver.removeField(classDescr, propertyTO.getName());
                }
                modelDriver.createField(classDescr, property);
                preservedFields.put(property.getName(), property.getName());
                continue;
            }
            if (propertyTO.nameChanged()) {
                if (currentFields.containsKey(propertyTO.getOriginalName())) {
                    modelDriver.updateField(classDescr, propertyTO.getOriginalName(), property, classTypeResolver);
                    preservedFields.put(propertyTO.getName(), propertyTO.getName());
                    continue;
                }
                if (currentFields.containsKey(propertyTO.getName())) {
                    modelDriver.removeField(classDescr, propertyTO.getName());
                }
                modelDriver.createField(classDescr, property);
                preservedFields.put(property.getName(), property.getName());
                continue;
            }
            if (currentFields.containsKey(propertyTO.getName())) {
                modelDriver.updateField(classDescr, propertyTO.getName(), property, classTypeResolver);
            } else {
                modelDriver.createField(classDescr, property);
            }
            preservedFields.put(property.getName(), property.getName());
        }
        modelDriver.updateConstructors(classDescr, dataObject);
        ArrayList<String> removableFields = new ArrayList<String>();
        for (FieldDescr fieldDescr : classDescr.getFields()) {
            for (VariableDeclarationDescr variableDescr : fieldDescr.getVariableDeclarations()) {
                if (preservedFields.containsKey(variableDescr.getIdentifier().getIdentifier()) || variableDescr.getDimensionsCount() != 0 || !modelDriver.isManagedField(fieldDescr, classTypeResolver)) continue;
                removableFields.add(variableDescr.getIdentifier().getIdentifier());
            }
        }
        for (String fieldName : removableFields) {
            modelDriver.removeField(classDescr, fieldName);
        }
    }
}

