/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.SimpleNamingScheme;
import org.jboss.weld.context.beanstore.http.EagerSessionBeanStore;
import org.jboss.weld.context.beanstore.http.LazySessionBeanStore;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.slf4j.cal10n.LocLogger;

public class HttpSessionContextImpl
extends AbstractBoundContext<HttpServletRequest>
implements HttpSessionContext {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final NamingScheme namingScheme = new SimpleNamingScheme(HttpSessionContext.class.getName());

    public HttpSessionContextImpl() {
        super(true);
    }

    public boolean associate(HttpServletRequest request) {
        if (this.getBeanStore() != null) {
            log.warn((Enum)ContextMessage.BEAN_STORE_LEAK_DURING_ASSOCIATION, new Object[]{this.getClass().getName(), request});
        }
        this.setBeanStore(new LazySessionBeanStore(request, this.namingScheme));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy(HttpSession session) {
        if (this.getBeanStore() == null) {
            try {
                HttpConversationContext conversationContext = this.getConversationContext();
                this.setBeanStore(new EagerSessionBeanStore(this.namingScheme, session));
                this.activate();
                this.invalidate();
                conversationContext.destroy(session);
                this.deactivate();
                this.setBeanStore(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        HttpConversationContext conversationContext = this.getConversationContext();
        this.invalidate();
        if (conversationContext.isActive()) {
            for (ManagedConversation conversation : conversationContext.getConversations()) {
                if (conversation.isTransient()) continue;
                conversation.end();
            }
        } else {
            this.getConversationContext().destroy(session);
        }
        return false;
    }

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    protected HttpConversationContext getConversationContext() {
        return (HttpConversationContext)Container.instance().deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
    }
}

