/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.workbench.models.commons.backend.oracle.ProjectDataModelOracleImpl;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.MethodInfo;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.BaseFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassMethodInspector;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassToGenericClassConverter;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.JavaTypeSystemTranslator;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.AnnotationUtils;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.BlackLists;

public class ClassFactBuilder
extends BaseFactBuilder {
    private final ClassToGenericClassConverter typeSystemConverter = new JavaTypeSystemTranslator();
    private final Map<String, List<MethodInfo>> methodInformation = new HashMap<String, List<MethodInfo>>();
    private final Map<String, String> fieldParametersType = new HashMap<String, String>();
    private final List<String> superTypes;
    private final Set<org.drools.workbench.models.datamodel.oracle.Annotation> annotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
    private final Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> fieldAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
    private final Map<String, FactBuilder> fieldFactBuilders = new HashMap<String, FactBuilder>();

    public ClassFactBuilder(ProjectDataModelOracleBuilder builder, Class<?> clazz, boolean isEvent, TypeSource typeSource) throws IOException {
        this(builder, new HashMap<String, FactBuilder>(), clazz, isEvent, typeSource);
    }

    public ClassFactBuilder(ProjectDataModelOracleBuilder builder, Map<String, FactBuilder> discoveredFieldFactBuilders, Class<?> clazz, boolean isEvent, TypeSource typeSource) throws IOException {
        super(builder, clazz, isEvent, typeSource);
        this.superTypes = this.getSuperTypes(clazz);
        this.annotations.addAll(this.getAnnotations(clazz));
        this.fieldAnnotations.putAll(this.getFieldsAnnotations(clazz));
        this.loadClassFields(clazz, discoveredFieldFactBuilders);
    }

    @Override
    public void build(ProjectDataModelOracleImpl oracle) {
        super.build(oracle);
        oracle.addProjectMethodInformation(this.methodInformation);
        oracle.addProjectFieldParametersType(this.fieldParametersType);
        oracle.addProjectSuperTypes(this.buildSuperTypes());
        oracle.addProjectTypeAnnotations(this.buildTypeAnnotations());
        oracle.addProjectTypeFieldsAnnotations(this.buildTypeFieldsAnnotations());
    }

    private List<String> getSuperTypes(Class<?> clazz) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Class<?> superType = clazz.getSuperclass(); superType != null; superType = superType.getSuperclass()) {
            strings.add(superType.getName());
        }
        return strings;
    }

    protected Set<org.drools.workbench.models.datamodel.oracle.Annotation> getAnnotations(Class<?> clazz) {
        Annotation[] annotations;
        LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation> dmoAnnotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
        for (Annotation a : annotations = clazz.getAnnotations()) {
            org.drools.workbench.models.datamodel.oracle.Annotation dmoa = new org.drools.workbench.models.datamodel.oracle.Annotation(a.annotationType().getName());
            for (Method m : a.annotationType().getDeclaredMethods()) {
                String methodName = m.getName();
                dmoa.addAttribute(methodName, AnnotationUtils.getAnnotationAttributeValue(a, methodName));
            }
            dmoAnnotations.add(dmoa);
        }
        return dmoAnnotations;
    }

    private Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> getFieldsAnnotations(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> fieldsAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
        for (Field field : fields) {
            String fieldName = field.getName();
            Set<org.drools.workbench.models.datamodel.oracle.Annotation> fieldAnnotations = this.getFieldAnnotations(field);
            if (fieldAnnotations.size() <= 0) continue;
            fieldsAnnotations.put(fieldName, fieldAnnotations);
        }
        return fieldsAnnotations;
    }

    private Set<org.drools.workbench.models.datamodel.oracle.Annotation> getFieldAnnotations(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation> fieldAnnotations = new LinkedHashSet<org.drools.workbench.models.datamodel.oracle.Annotation>();
        for (Annotation a : annotations) {
            org.drools.workbench.models.datamodel.oracle.Annotation fieldAnnotation = new org.drools.workbench.models.datamodel.oracle.Annotation(a.annotationType().getName());
            for (Method m : a.annotationType().getDeclaredMethods()) {
                String methodName = m.getName();
                fieldAnnotation.addAttribute(methodName, AnnotationUtils.getAnnotationAttributeValue(a, methodName));
            }
            fieldAnnotations.add(fieldAnnotation);
        }
        return fieldAnnotations;
    }

    private void loadClassFields(Class<?> clazz, Map<String, FactBuilder> discoveredFieldFactBuilders) throws IOException {
        if (clazz == null) {
            return;
        }
        String factType = this.getType();
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        TreeSet<String> fieldNamesSet = new TreeSet<String>(inspector.getFieldNames().keySet());
        List<String> fieldNames = this.removeIrrelevantFields(clazz, inspector, fieldNamesSet);
        Method[] methods = clazz.getMethods();
        Map<String, MethodSignature> methodSignatures = this.removeIrrelevantMethods(this.getMethodSignatures(factType, methods));
        for (String fieldName : fieldNames) {
            FieldAccessorsAndMutators accessorAndMutator;
            String qualifiedName = factType + "." + fieldName;
            Field f = (Field)inspector.getFieldTypesField().get(fieldName);
            if (f == null) {
                if (!methodSignatures.containsKey(qualifiedName)) continue;
                MethodSignature m = methodSignatures.get(qualifiedName);
                this.addParametricTypeForField(factType, fieldName, m.genericType);
                Class returnType = m.returnType;
                String genericReturnType = this.typeSystemConverter.translateClassToGenericType(returnType);
                FieldAccessorsAndMutators accessorAndMutator2 = methodSignatures.containsKey(qualifiedName) ? methodSignatures.get(qualifiedName).accessorAndMutator : FieldAccessorsAndMutators.BOTH;
                this.addField(new ModelField(fieldName, returnType.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DELEGATED, accessorAndMutator2, genericReturnType));
                this.addEnumsForField(factType, fieldName, returnType);
                continue;
            }
            Field field = (Field)inspector.getFieldTypesField().get(fieldName);
            this.addParametricTypeForField(factType, fieldName, field.getGenericType());
            Field[] _declaredClassFields = clazz.getDeclaredFields();
            List<Field> declaredClassFields = _declaredClassFields != null ? Arrays.asList(_declaredClassFields) : Collections.EMPTY_LIST;
            Class<?> returnType = field.getType();
            String genericReturnType = this.typeSystemConverter.translateClassToGenericType(returnType);
            FieldAccessorsAndMutators fieldAccessorsAndMutators = accessorAndMutator = methodSignatures.containsKey(qualifiedName) ? methodSignatures.get(qualifiedName).accessorAndMutator : FieldAccessorsAndMutators.BOTH;
            if (!discoveredFieldFactBuilders.containsKey(genericReturnType)) {
                discoveredFieldFactBuilders.put(genericReturnType, null);
                discoveredFieldFactBuilders.put(genericReturnType, new ClassFactBuilder(this.builder, discoveredFieldFactBuilders, returnType, false, this.typeSource));
            }
            if (discoveredFieldFactBuilders.get(genericReturnType) != null) {
                this.fieldFactBuilders.put(genericReturnType, discoveredFieldFactBuilders.get(genericReturnType));
            }
            this.addField(new ModelField(fieldName, returnType.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, declaredClassFields.contains(field) ? ModelField.FIELD_ORIGIN.DECLARED : ModelField.FIELD_ORIGIN.INHERITED, accessorAndMutator, genericReturnType));
            this.addEnumsForField(factType, fieldName, returnType);
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this.typeSystemConverter);
        List<MethodInfo> methodInformation = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInformation) {
            String genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            String qualifiedFactFieldName = factType + "#" + mi.getNameWithParameters();
            this.fieldParametersType.put(qualifiedFactFieldName, genericType);
        }
        this.methodInformation.put(factType, methodInformation);
    }

    private List<String> removeIrrelevantFields(Class<?> clazz, ClassFieldInspector inspector, Set<String> fieldNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            if (inspector.isNonGetter(fieldName) || BlackLists.isClassMethodBlackListed(clazz, fieldName)) continue;
            result.add(fieldName);
        }
        return result;
    }

    private Map<String, MethodSignature> removeIrrelevantMethods(Map<String, MethodSignature> methods) {
        HashMap<String, MethodSignature> result = new HashMap<String, MethodSignature>();
        for (Map.Entry<String, MethodSignature> methodSignature : methods.entrySet()) {
            String methodName = methodSignature.getKey();
            if ((methodName = methodName.substring(methodName.lastIndexOf(".") + 1)).equals("class")) continue;
            result.put(methodSignature.getKey(), methodSignature.getValue());
        }
        return result;
    }

    private Map<String, MethodSignature> getMethodSignatures(String factType, Method[] methods) {
        HashMap<String, MethodSignature> methodSignatures = new HashMap<String, MethodSignature>();
        for (Method method : methods) {
            MethodSignature signature;
            String factField;
            String name = method.getName();
            if (method.getParameterTypes().length > 0) {
                name = name.startsWith("set") ? Introspector.decapitalize(name.substring(3)) : Introspector.decapitalize(name);
                factField = factType + "." + name;
                if (!methodSignatures.containsKey(factField)) {
                    methodSignatures.put(factField, new MethodSignature(FieldAccessorsAndMutators.MUTATOR, Void.TYPE.getGenericSuperclass(), Void.TYPE));
                    continue;
                }
                if (((MethodSignature)methodSignatures.get(factField)).accessorAndMutator != FieldAccessorsAndMutators.ACCESSOR) continue;
                signature = (MethodSignature)methodSignatures.get(factField);
                signature.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
                continue;
            }
            if (method.getReturnType().getName().equals("void")) continue;
            name = name.startsWith("get") ? Introspector.decapitalize(name.substring(3)) : (name.startsWith("is") ? Introspector.decapitalize(name.substring(2)) : Introspector.decapitalize(name));
            factField = factType + "." + name;
            if (!methodSignatures.containsKey(factField)) {
                methodSignatures.put(factField, new MethodSignature(FieldAccessorsAndMutators.ACCESSOR, method.getGenericReturnType(), method.getReturnType()));
                continue;
            }
            if (((MethodSignature)methodSignatures.get(factField)).accessorAndMutator != FieldAccessorsAndMutators.MUTATOR) continue;
            signature = (MethodSignature)methodSignatures.get(factField);
            signature.accessorAndMutator = FieldAccessorsAndMutators.BOTH;
            signature.genericType = method.getGenericReturnType();
            signature.returnType = method.getReturnType();
        }
        return methodSignatures;
    }

    private void addEnumsForField(String className, String fieldName, Class<?> fieldClazz) {
        if (fieldClazz.isEnum()) {
            Field[] enumFields = fieldClazz.getDeclaredFields();
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Field enumField : enumFields) {
                if (!enumField.isEnumConstant()) continue;
                String shortName = fieldClazz.getName().substring(fieldClazz.getName().lastIndexOf(".") + 1) + "." + enumField.getName();
                if (shortName.contains("$")) {
                    shortName = shortName.replaceAll("\\$", ".");
                }
                enumValues.add(shortName + "=" + shortName);
            }
            String[] a = new String[enumValues.size()];
            enumValues.toArray(a);
            this.getDataModelBuilder().addEnum(className, fieldName, a);
        }
    }

    private void addParametricTypeForField(String className, String fieldName, Type type) {
        String qualifiedFactFieldName = className + "#" + fieldName;
        String parametricType = this.getParametricType(type);
        if (parametricType != null) {
            this.fieldParametersType.put(qualifiedFactFieldName, parametricType);
        }
    }

    private String getParametricType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type parameter = null;
            Type[] arr$ = pt.getActualTypeArguments();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type t;
                parameter = t = arr$[i$];
            }
            if (parameter != null) {
                if (parameter instanceof Class) {
                    return ((Class)parameter).getName();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Map<String, List<String>> buildSuperTypes() {
        HashMap<String, List<String>> loadableSuperTypes = new HashMap<String, List<String>>();
        loadableSuperTypes.put(this.getType(), this.superTypes);
        return loadableSuperTypes;
    }

    private Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> buildTypeAnnotations() {
        HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>> loadableTypeAnnotations = new HashMap<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>();
        loadableTypeAnnotations.put(this.getType(), this.annotations);
        return loadableTypeAnnotations;
    }

    private Map<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>> buildTypeFieldsAnnotations() {
        HashMap<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>> loadableTypeFieldsAnnotations = new HashMap<String, Map<String, Set<org.drools.workbench.models.datamodel.oracle.Annotation>>>();
        loadableTypeFieldsAnnotations.put(this.getType(), this.fieldAnnotations);
        return loadableTypeFieldsAnnotations;
    }

    @Override
    public Map<String, FactBuilder> getInternalBuilders() {
        for (FactBuilder factBuilder : new ArrayList<FactBuilder>(this.fieldFactBuilders.values())) {
            this.fieldFactBuilders.putAll(factBuilder.getInternalBuilders());
        }
        return this.fieldFactBuilders;
    }

    private static class MethodSignature {
        private FieldAccessorsAndMutators accessorAndMutator;
        private Type genericType;
        private Class<?> returnType;

        private MethodSignature(FieldAccessorsAndMutators accessorAndMutator, Type genericType, Class<?> returnType) {
            this.accessorAndMutator = accessorAndMutator;
            this.genericType = genericType;
            this.returnType = returnType;
        }
    }
}

