/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlackLists {
    public static boolean isClassMethodBlackListed(Class<?> clazz, String methodName) {
        if ("class".equals(methodName) || "hashCode".equals(methodName) || "equals".equals(methodName) || "toString".equals(methodName)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz) && BlackLists.isInCollectionMethodsBlackList(methodName)) {
            return true;
        }
        if (Set.class.isAssignableFrom(clazz) && BlackLists.isInSetMethodsBlackList(methodName)) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz) && BlackLists.isInListMethodsBlackList(methodName)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz) && BlackLists.isInMapMethodsBlackList(methodName);
    }

    private static boolean isInCollectionMethodsBlackList(String methodName) {
        return "addAll".equals(methodName) || "containsAll".equals(methodName) || "iterator".equals(methodName) || "removeAll".equals(methodName) || "retainAll".equals(methodName) || "toArray".equals(methodName);
    }

    private static boolean isInSetMethodsBlackList(String methodName) {
        return "addAll".equals(methodName) || "containsAll".equals(methodName) || "iterator".equals(methodName) || "removeAll".equals(methodName) || "retainAll".equals(methodName) || "toArray".equals(methodName);
    }

    private static boolean isInListMethodsBlackList(String methodName) {
        return "addAll".equals(methodName) || "containsAll".equals(methodName) || "iterator".equals(methodName) || "listIterator".equals(methodName) || "removeAll".equals(methodName) || "retainAll".equals(methodName) || "subList".equals(methodName) || "toArray".equals(methodName);
    }

    private static boolean isInMapMethodsBlackList(String methodName) {
        return "entrySet".equals(methodName) || "keySet".equals(methodName) || "putAll".equals(methodName);
    }
}

