/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.POMService;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.file.AntPathMatcher;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Named(value="ProjectDataModelOracleCache")
public class LRUProjectDataModelOracleCache
extends LRUCache<KieProject, ProjectDataModelOracle> {
    private static final Logger log = LoggerFactory.getLogger(LRUProjectDataModelOracleCache.class);
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    @Inject
    private POMService pomService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private KieProjectService projectService;
    @Inject
    private ProjectImportsService importsService;
    @Inject
    private LRUBuilderCache cache;

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        KieProject project = (KieProject)this.projectService.resolveProject(resourcePath);
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized ProjectDataModelOracle assertProjectDataModelOracle(KieProject project) {
        ProjectDataModelOracle projectOracle = (ProjectDataModelOracle)this.getEntry(project);
        if (projectOracle == null) {
            projectOracle = this.makeProjectOracle(project);
            this.setEntry(project, projectOracle);
        }
        return projectOracle;
    }

    private ProjectDataModelOracle makeProjectOracle(KieProject project) {
        Builder builder = this.cache.assertBuilder((Project)project);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)builder.getKieModuleIgnoringErrors());
        ProjectDataModelOracleBuilder pdBuilder = ProjectDataModelOracleBuilder.newProjectOracleBuilder();
        Set<String> packageNamesWhiteList = this.loadPackageNameWhiteList(project, kieModuleMetaData.getPackages());
        pdBuilder.addPackages(packageNamesWhiteList);
        HashMap<String, FactBuilder> discoveredFieldFactBuilders = new HashMap<String, FactBuilder>();
        for (String packageName : kieModuleMetaData.getPackages()) {
            if (!packageNamesWhiteList.contains(packageName)) continue;
            for (String className : kieModuleMetaData.getClasses(packageName)) {
                try {
                    Class clazz = kieModuleMetaData.getClass(packageName, className);
                    TypeMetaInfo typeMetaInfo = kieModuleMetaData.getTypeMetaInfo(clazz);
                    TypeSource typeSource = builder.getClassSource(kieModuleMetaData, clazz);
                    pdBuilder.addClass(clazz, discoveredFieldFactBuilders, typeMetaInfo.isEvent(), typeSource);
                }
                catch (Throwable e) {
                    log.error(e.getMessage());
                }
            }
        }
        Path nioExternalImportsPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getImportsPath());
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = Paths.convert((Path)nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.importsService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(item.getType());
                    pdBuilder.addClass(clazz, discoveredFieldFactBuilders, false, TypeSource.JAVA_DEPENDENCY);
                }
                catch (ClassNotFoundException cnfe) {
                    log.error(cnfe.getMessage());
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
        }
        return pdBuilder.build();
    }

    private Set<String> loadPackageNameWhiteList(KieProject project, Collection<String> packageNames) {
        String content;
        HashSet<String> packageNamesWhiteList = new HashSet<String>();
        if (packageNames == null) {
            return packageNamesWhiteList;
        }
        packageNamesWhiteList.addAll(packageNames);
        Path packageNamesWhiteListPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getPackageNamesWhiteList());
        if (Files.exists((Path)packageNamesWhiteListPath, (LinkOption[])new LinkOption[0]) && (content = this.ioService.readAllString(packageNamesWhiteListPath)) != null && !content.trim().isEmpty()) {
            packageNamesWhiteList.clear();
            String[] patterns = content.split(System.getProperty("line.separator"));
            for (int i = 0; i < patterns.length; ++i) {
                patterns[i] = patterns[i].replaceAll("\\.", "/");
            }
            HashMap<String, String> packageNamePaths = new HashMap<String, String>();
            for (String packageName : packageNames) {
                packageNamePaths.put(packageName, packageName.replaceAll("\\.", "/"));
            }
            for (String pattern : patterns) {
                for (Map.Entry pnp : packageNamePaths.entrySet()) {
                    if (!ANT_PATH_MATCHER.match(pattern, (String)pnp.getValue())) continue;
                    packageNamesWhiteList.add((String)pnp.getKey());
                }
            }
        }
        return packageNamesWhiteList;
    }
}

