/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassTypeResolver;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverListener;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.driver.impl.DefaultJavaModelAnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.CommonAnnotations;
import org.kie.workbench.common.services.datamodeller.parser.JavaParser;
import org.kie.workbench.common.services.datamodeller.parser.JavaParserFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.AnnotationDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.DescriptorFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.DescriptorFactoryImpl;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.MethodDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierListDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifiersContainerDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.PackageDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.QualifiedNameDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TextTokenElementDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.TypeDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.VariableDeclarationDescr;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class JavaModelDriver
implements ModelDriver {
    private static final Logger logger = LoggerFactory.getLogger(JavaModelDriver.class);
    IOService ioService;
    boolean recursiveScan;
    Path javaRootPath;
    private ClassLoader classLoader;
    private List<AnnotationDefinition> configuredAnnotations = new ArrayList<AnnotationDefinition>();
    private Map<String, AnnotationDefinition> configuredAnnotationsIndex = new HashMap<String, AnnotationDefinition>();
    private Map<String, AnnotationDriver> annotationDrivers = new HashMap<String, AnnotationDriver>();
    static final String[] indentationOptions = new String[]{"\n\n    ", "\n\n   ", "\n\n  ", "\n\n ", "\n\n", "\n    ", "\n   ", "\n  ", "\n ", "\n"};
    static final String[] modifiersIndentationOptions = new String[]{"\n    ", "\n   ", "\n  ", "\n ", "\n"};

    public JavaModelDriver() {
        this.configuredAnnotations.addAll(CommonAnnotations.getCommonAnnotations());
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultJavaModelAnnotationDriver());
            this.configuredAnnotationsIndex.put(annotationDefinition.getClassName(), annotationDefinition);
        }
    }

    public JavaModelDriver(IOService ioService, Path javaRootPath, boolean recursiveScan, ClassLoader classLoader) {
        this();
        this.ioService = ioService;
        this.recursiveScan = recursiveScan;
        this.javaRootPath = javaRootPath;
        this.classLoader = classLoader;
    }

    @Override
    public List<AnnotationDefinition> getConfiguredAnnotations() {
        return this.configuredAnnotations;
    }

    @Override
    public AnnotationDefinition getConfiguredAnnotation(String annotationClassName) {
        return this.configuredAnnotationsIndex.get(annotationClassName);
    }

    @Override
    public AnnotationDriver getAnnotationDriver(String annotationClassName) {
        return this.annotationDrivers.get(annotationClassName);
    }

    @Override
    public void generateModel(DataModel dataModel, ModelDriverListener generationListener) throws Exception {
    }

    @Override
    public ModelDriverResult loadModel() throws ModelDriverException {
        DataModel dataModel = this.createModel();
        ArrayList<Path> rootPaths = new ArrayList<Path>();
        rootPaths.add(this.javaRootPath);
        Collection<FileUtils.ScanResult> scanResults = FileUtils.getInstance().scan(this.ioService, rootPaths, ".java", true);
        if (scanResults != null) {
            for (FileUtils.ScanResult scanResult : scanResults) {
                logger.debug("Starting processing for file: " + scanResult.getFile());
                String fileContent = this.ioService.readAllString(scanResult.getFile());
                if (fileContent == null || "".equals(fileContent)) {
                    logger.debug("file: " + scanResult.getFile() + " is empty.");
                    continue;
                }
                try {
                    JavaParser parser = JavaParserFactory.newParser(fileContent);
                    parser.compilationUnit();
                    if (parser.getFileDescr().getClassDescr() != null) {
                        this.addDataObject(dataModel, parser.getFileDescr());
                        continue;
                    }
                    logger.debug("No Class definition was found for file: " + scanResult.getFile());
                }
                catch (Exception e) {
                    logger.error("An error was produced during file parsing: " + scanResult.getFile(), (Throwable)e);
                    throw new ModelDriverException(e.getMessage(), e);
                }
            }
        }
        return new ModelDriverResult(dataModel);
    }

    @Override
    public DataModel createModel() {
        return ModelFactoryImpl.getInstance().newModel();
    }

    private DataObject addDataObject(DataModel dataModel, FileDescr fileDescr) throws ModelDriverException {
        List<FieldDescr> fields;
        List<AnnotationDescr> classAnnotations;
        ClassDescr classDescr = fileDescr.getClassDescr();
        PackageDescr packageDescr = fileDescr.getPackageDescr();
        String className = classDescr.getIdentifier().getIdentifier();
        String packageName = packageDescr != null ? packageDescr.getPackageName() : "";
        int modifiers = 0;
        DriverUtils driverUtils = DriverUtils.getInstance();
        if (logger.isDebugEnabled()) {
            logger.debug("Building DataObject for, packageName: " + packageName + ", className: " + className);
        }
        ClassTypeResolver classTypeResolver = DriverUtils.getInstance().createClassTypeResolver(fileDescr, this.classLoader);
        modifiers = classDescr.getModifiers() != null ? driverUtils.buildModifierRepresentation(classDescr.getModifiers().getModifiers()) : 0;
        DataObject dataObject = dataModel.addDataObject(packageName, className, modifiers);
        TypeDescr typeDescr = classDescr.getSuperClass();
        if (typeDescr != null && typeDescr.isClassOrInterfaceType()) {
            String superClass = typeDescr.getClassOrInterfaceType().getClassName();
            superClass = this.resolveTypeName(classTypeResolver, superClass);
            dataObject.setSuperClassName(superClass);
        }
        List<AnnotationDescr> list = classAnnotations = classDescr.getModifiers() != null ? classDescr.getModifiers().getAnnotations() : null;
        if (classAnnotations != null) {
            for (AnnotationDescr classAnnotation : classAnnotations) {
                this.addDataObjectAnnotation(dataObject, classAnnotation, classTypeResolver);
            }
        }
        if ((fields = classDescr.getFields()) != null) {
            for (FieldDescr field : fields) {
                if (this.isManagedType(field.getType(), classTypeResolver)) {
                    this.addProperty(dataObject, field, classTypeResolver);
                    continue;
                }
                logger.debug("field: " + field + " won't be loadoded by the diver because type: " + field.getType().getName() + " isn't a managed type.");
            }
        }
        return dataObject;
    }

    private boolean isManagedType(TypeDescr typeDescr, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        return DriverUtils.getInstance().isManagedType(typeDescr, classTypeResolver);
    }

    private String resolveTypeName(ClassTypeResolver classTypeResolver, String name) throws ModelDriverException {
        try {
            Class typeClass = classTypeResolver.resolveType(name);
            return typeClass.getName();
        }
        catch (ClassNotFoundException e) {
            logger.error("Class could not be resolved for name: " + name, (Throwable)e);
            throw new ModelDriverException("Class could not be resolved for name: " + name + ". " + e.getMessage(), e);
        }
    }

    private void addDataObjectAnnotation(DataObject dataObject, AnnotationDescr annotationDescr, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationDescr, classTypeResolver);
        if (annotation != null) {
            dataObject.addAnnotation(annotation);
        }
    }

    private void addProperty(DataObject dataObject, FieldDescr field, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        String className;
        boolean multiple = false;
        String bag = null;
        int modifiers = 0;
        DriverUtils driverUtils = DriverUtils.getInstance();
        TypeDescr typeDescr = field.getType();
        if (typeDescr.isPrimitiveType()) {
            className = typeDescr.getPrimitiveType().getName();
        } else if (driverUtils.isSimpleClass(typeDescr)) {
            className = typeDescr.getClassOrInterfaceType().getClassName();
            className = this.resolveTypeName(classTypeResolver, className);
        } else {
            multiple = true;
            Object[] split = driverUtils.isSimpleGeneric(typeDescr);
            bag = this.resolveTypeName(classTypeResolver, split[1].toString());
            className = ((TypeDescr)split[2]).getName();
            className = this.resolveTypeName(classTypeResolver, className);
        }
        List<VariableDeclarationDescr> variableDeclarations = field.getVariableDeclarations();
        int n = modifiers = field.getModifiers() != null ? driverUtils.buildModifierRepresentation(field.getModifiers().getModifiers()) : 0;
        if (variableDeclarations != null) {
            for (VariableDeclarationDescr variable : variableDeclarations) {
                ObjectProperty property = multiple ? dataObject.addProperty(variable.getIdentifier().getIdentifier(), className, true, bag, modifiers) : dataObject.addProperty(variable.getIdentifier().getIdentifier(), className, modifiers);
                List<AnnotationDescr> fieldAnnotations = field.getModifiers() != null ? field.getModifiers().getAnnotations() : null;
                if (fieldAnnotations == null) continue;
                for (AnnotationDescr fieldAnnotation : fieldAnnotations) {
                    this.addPropertyAnnotation(property, fieldAnnotation, classTypeResolver);
                }
            }
        }
    }

    private void addPropertyAnnotation(ObjectProperty property, AnnotationDescr annotationDescr, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationDescr, classTypeResolver);
        if (annotation != null) {
            property.addAnnotation(annotation);
        }
    }

    private Annotation createAnnotation(AnnotationDescr annotationToken, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        String annotationClassName = this.resolveTypeName(classTypeResolver, annotationToken.getQualifiedName().getName());
        AnnotationDefinition annotationDefinition = this.getConfiguredAnnotation(annotationClassName);
        Annotation annotation = null;
        if (annotationDefinition != null) {
            AnnotationDriver annotationDriver = this.getAnnotationDriver(annotationDefinition.getClassName());
            if (annotationDriver != null) {
                annotation = annotationDriver.buildAnnotation(annotationDefinition, annotationToken);
            } else {
                logger.warn("AnnotationDriver for annotation: " + annotationToken.getQualifiedName().getName() + " is not configured for this driver");
            }
        } else {
            logger.warn("Annotation: " + annotationToken.getQualifiedName().getName() + " is not configured for this driver.");
        }
        return annotation;
    }

    public boolean isManagedField(FieldDescr fieldDescr, ClassTypeResolver classTypeResolver) throws Exception {
        List<ModifierDescr> modifiers;
        ModifierListDescr modifierListDescr = fieldDescr.getModifiers();
        List<ModifierDescr> list = modifiers = modifierListDescr != null ? modifierListDescr.getModifiers() : null;
        if (modifiers != null) {
            for (ModifierDescr modifier : modifiers) {
                if (!"static".equals(modifier.getName()) && !"final".equals(modifier.getName())) continue;
                return false;
            }
        }
        return DriverUtils.getInstance().isManagedType(fieldDescr.getType(), classTypeResolver);
    }

    public void updateClassOrFieldAnnotations(ElementDescriptor parent, ModifiersContainerDescr modifiersContainer, List<Annotation> annotations, ClassTypeResolver classTypeResolver) throws Exception {
        List<ModifierDescr> oldModifiers;
        ArrayList<AnnotationDescr> unmangedAnnotations = new ArrayList<AnnotationDescr>();
        int currentManagedAnnotations = 0;
        boolean isClass = modifiersContainer instanceof ClassDescr;
        JavaModelDriver driver = new JavaModelDriver();
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        GenerationContext generationContext = new GenerationContext(null);
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationTools genTools = new GenerationTools();
        ModifierListDescr modifierList = modifiersContainer.getModifiers();
        List<AnnotationDescr> oldAnnotations = modifierList != null ? modifierList.getAnnotations() : null;
        List<ModifierDescr> list = oldModifiers = modifierList != null ? modifierList.getModifiers() : null;
        if (oldAnnotations != null) {
            for (AnnotationDescr oldAnnotation : oldAnnotations) {
                String annotationClassName = classTypeResolver.getFullTypeName(oldAnnotation.getQualifiedName().getName());
                if (driver.getConfiguredAnnotation(annotationClassName) == null) {
                    unmangedAnnotations.add(oldAnnotation);
                    continue;
                }
                ++currentManagedAnnotations;
            }
        }
        if (currentManagedAnnotations > 0 || annotations != null && annotations.size() > 0) {
            ModifierListDescr newModifierList = new ModifierListDescr();
            for (Annotation annotation : annotations) {
                String source = engine.generateAnnotationString(generationContext, annotation);
                source = isClass ? genTools.indentClassAnnotation(source) : genTools.indentFieldAnnotation(source);
                AnnotationDescr newAnnotationDescr = descriptorFactory.createAnnotationDescr(source, true);
                newModifierList.getElements().add(newAnnotationDescr);
            }
            for (AnnotationDescr unmanagedAnnotation : unmangedAnnotations) {
                StringBuilder indentString = isClass ? new StringBuilder("\n") : new StringBuilder("\n    ");
                TextTokenElementDescr indent = new TextTokenElementDescr(indentString.toString(), 0, indentString.length() - 1, 1, 0);
                indent.setSourceBuffer(indentString);
                unmanagedAnnotation.getElements().add(0, indent);
                newModifierList.add(unmanagedAnnotation);
            }
            boolean first = true;
            if (oldModifiers != null) {
                for (ModifierDescr oldModifier : oldModifiers) {
                    if (first) {
                        StringBuilder indentString = isClass ? new StringBuilder("\n") : new StringBuilder("\n    ");
                        TextTokenElementDescr indent = new TextTokenElementDescr(indentString.toString(), 0, indentString.length() - 1, 1, 0);
                        indent.setSourceBuffer(indentString);
                        newModifierList.getElements().add(indent);
                    }
                    first = false;
                    newModifierList.add(oldModifier);
                }
            }
            if (newModifierList.size() > 0) {
                if (modifierList == null) {
                    StringBuilder spaceString = new StringBuilder(" ");
                    TextTokenElementDescr spaceTextToken = new TextTokenElementDescr(spaceString.toString(), 0, spaceString.length() - 1, 1, 0);
                    spaceTextToken.setSourceBuffer(spaceString);
                    if (isClass) {
                        IdentifierDescr identifierDescr = ((ClassDescr)modifiersContainer).getIdentifier();
                        modifiersContainer.getElements().addMemberBefore(identifierDescr, spaceTextToken);
                    } else {
                        modifiersContainer.getElements().add(0, spaceTextToken);
                    }
                    modifiersContainer.getElements().addMemberBefore(spaceTextToken, newModifierList);
                } else {
                    modifiersContainer.getElements().addElementAfter(modifierList, newModifierList);
                }
            }
            if (modifierList != null) {
                if (newModifierList.size() > 0) {
                    this.adjustTokenIndent(parent, modifiersContainer, modifiersIndentationOptions);
                }
                modifiersContainer.getElements().remove(modifierList);
            }
        }
    }

    public void updateConstructors(ClassDescr classDescr, DataObject dataObject) throws Exception {
        List<FieldDescr> fields;
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        GenerationContext generationContext = new GenerationContext(null);
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationTools genTools = new GenerationTools();
        MethodDescr defaultConstructor = null;
        MethodDescr allFieldsConstructor = null;
        MethodDescr keyFieldsConstructor = null;
        MethodDescr equalsMethod = null;
        MethodDescr hashCodeMethod = null;
        int keyFieldsCount = 0;
        int assignableFieldsCount = 0;
        ElementDescriptor constructorsInsertionPoint = null;
        ElementDescriptor equalsInsertionPoint = null;
        MethodDescr hashCodeInsertionPoint = null;
        assignableFieldsCount = DataModelUtils.assignableFieldsCount(dataObject);
        keyFieldsCount = DataModelUtils.keyFieldsCount(dataObject);
        boolean needsKeyFieldsConstructor = keyFieldsCount > 0 && keyFieldsCount < assignableFieldsCount;
        List<MethodDescr> currentConstructors = classDescr.getConstructors();
        constructorsInsertionPoint = currentConstructors != null && currentConstructors.size() > 0 ? (ElementDescriptor)currentConstructors.get(currentConstructors.size() - 1) : ((fields = classDescr.getFields()) != null && fields.size() > 0 ? (ElementDescriptor)fields.get(fields.size() - 1) : classDescr.getBodyStartBrace());
        MethodDescr currentEquals = classDescr.getMethod("equals");
        MethodDescr currentHashCode = classDescr.getMethod("hashCode");
        defaultConstructor = descriptorFactory.createMethodDescr(genTools.indent(engine.generateDefaultConstructorString(generationContext, dataObject)), true);
        if (assignableFieldsCount > 0) {
            allFieldsConstructor = descriptorFactory.createMethodDescr(genTools.indent(engine.generateAllFieldsConstructorString(generationContext, dataObject)), true);
        }
        if (needsKeyFieldsConstructor) {
            keyFieldsConstructor = descriptorFactory.createMethodDescr(genTools.indent(engine.generateKeyFieldsConstructorString(generationContext, dataObject)), true);
        }
        if (keyFieldsCount > 0) {
            List<MethodDescr> methods;
            equalsMethod = descriptorFactory.createMethodDescr(genTools.indent(engine.generateEqualsString(generationContext, dataObject)), true);
            hashCodeMethod = descriptorFactory.createMethodDescr(genTools.indent(engine.generateHashCodeString(generationContext, dataObject)), true);
            equalsInsertionPoint = currentEquals != null ? currentEquals : ((methods = classDescr.getMethods()) != null && methods.size() > 0 ? (ElementDescriptor)methods.get(methods.size() - 1) : (keyFieldsConstructor != null ? keyFieldsConstructor : (allFieldsConstructor != null ? allFieldsConstructor : defaultConstructor)));
            hashCodeInsertionPoint = currentHashCode != null ? currentHashCode : equalsMethod;
        }
        if (defaultConstructor != null) {
            classDescr.getElements().addElementAfter(constructorsInsertionPoint, defaultConstructor);
            constructorsInsertionPoint = defaultConstructor;
        }
        if (allFieldsConstructor != null) {
            classDescr.getElements().addElementAfter(constructorsInsertionPoint, allFieldsConstructor);
            constructorsInsertionPoint = allFieldsConstructor;
        }
        if (keyFieldsConstructor != null) {
            classDescr.getElements().addElementAfter(constructorsInsertionPoint, keyFieldsConstructor);
        }
        if (keyFieldsCount > 0) {
            classDescr.getElements().addElementAfter(equalsInsertionPoint, equalsMethod);
            classDescr.getElements().addElementAfter(hashCodeInsertionPoint, hashCodeMethod);
        }
        if (currentConstructors != null) {
            for (MethodDescr constructor : currentConstructors) {
                this.adjustFieldOrMethodIndent(classDescr, constructor);
                classDescr.getElements().remove(constructor);
            }
        }
        if (currentEquals != null) {
            this.adjustFieldOrMethodIndent(classDescr, currentEquals);
            classDescr.getElements().remove(currentEquals);
        }
        if (currentHashCode != null) {
            this.adjustFieldOrMethodIndent(classDescr, currentHashCode);
            classDescr.getElements().remove(currentHashCode);
        }
    }

    public boolean updatePackage(FileDescr fileDescr, String packageName) throws Exception {
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        boolean hasChanged = false;
        if (packageName == null && fileDescr.getPackageDescr() != null) {
            fileDescr.getElements().remove(fileDescr.getPackageDescr());
            hasChanged = true;
        } else if (packageName != null && fileDescr.getPackageDescr() == null) {
            PackageDescr packageDescr = descriptorFactory.createPackageDescr("package " + packageName + ";");
            fileDescr.getElements().add(0, packageDescr);
            hasChanged = true;
        } else if (packageName != null && fileDescr.getPackageDescr() != null && !packageName.equals(fileDescr.getPackageDescr().getPackageName())) {
            PackageDescr packageDescr = fileDescr.getPackageDescr();
            QualifiedNameDescr oldPackageName = packageDescr.getQualifiedName();
            QualifiedNameDescr newPackageName = descriptorFactory.createQualifiedNameDescr(packageName);
            packageDescr.getElements().addMemberBefore(oldPackageName, newPackageName);
            packageDescr.getElements().remove(oldPackageName);
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean updateClassName(ClassDescr classDescr, String name) throws Exception {
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        boolean hasChanged = false;
        if (!name.equals(classDescr.getName())) {
            IdentifierDescr oldIdentifier = classDescr.getIdentifier();
            IdentifierDescr newIdentifier = descriptorFactory.createIdentifierDescr(name);
            classDescr.getElements().addMemberBefore(oldIdentifier, newIdentifier);
            classDescr.getElements().remove(oldIdentifier);
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean updateSuperClassName(ClassDescr classDescr, String superClassName, ClassTypeResolver classTypeResolver) throws Exception {
        String currentSuperClass;
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        boolean hasChanged = false;
        if (superClassName == null && classDescr.hasSuperClass()) {
            classDescr.getElements().remove(classDescr.getExtendsToken());
            classDescr.getElements().remove(classDescr.getSuperClass());
            hasChanged = true;
        } else if (superClassName != null && !classDescr.hasSuperClass()) {
            TypeDescr superClassType = descriptorFactory.createTypeDescr(superClassName);
            JavaTokenDescr extendsToken = descriptorFactory.createExtendsTokenDescr();
            TextTokenElementDescr space1 = descriptorFactory.createTextTokenDescr(" ");
            TextTokenElementDescr space2 = descriptorFactory.createTextTokenDescr(" ");
            TextTokenElementDescr space3 = descriptorFactory.createTextTokenDescr(" ");
            classDescr.getElements().addElementAfter(classDescr.getIdentifier(), space1);
            classDescr.getElements().addElementAfter(space1, extendsToken);
            classDescr.getElements().addElementAfter(extendsToken, space2);
            classDescr.getElements().addElementAfter(space2, superClassType);
            classDescr.getElements().addElementAfter(superClassType, space3);
            hasChanged = true;
        } else if (superClassName != null && classDescr.hasSuperClass() && !superClassName.equals(currentSuperClass = classTypeResolver.getFullTypeName(classDescr.getSuperClass().getName()))) {
            TypeDescr oldSuperClass = classDescr.getSuperClass();
            TypeDescr newSuperClass = descriptorFactory.createTypeDescr(superClassName);
            classDescr.getElements().addMemberBefore(oldSuperClass, newSuperClass);
            classDescr.getElements().remove(oldSuperClass);
            hasChanged = true;
        }
        return hasChanged;
    }

    public void updateField(ClassDescr classDescr, String fieldName, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        FieldDescr targetFieldDescr;
        VariableDeclarationDescr variable;
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        GenerationTools genTools = new GenerationTools();
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        DriverUtils driverUtils = DriverUtils.getInstance();
        boolean updateAccessors = false;
        FieldDescr fieldDescr = classDescr.getField(fieldName);
        TypeDescr oldType = fieldDescr.getType();
        if (fieldDescr.getVariableDeclarations().size() > 1) {
            variable = fieldDescr.getVariableDeclaration(fieldName);
            String fieldStr = this.copyFieldVariableToString(fieldDescr, fieldName);
            targetFieldDescr = descriptorFactory.createFieldDescr(genTools.indent(fieldStr), true);
            fieldDescr.removeVariableDeclaration(variable);
            classDescr.addField(targetFieldDescr);
        } else {
            targetFieldDescr = fieldDescr;
        }
        variable = targetFieldDescr.getVariableDeclaration(fieldName);
        if (!fieldName.equals(property.getName())) {
            IdentifierDescr newIdentifier = descriptorFactory.createIdentifierDescr(property.getName());
            IdentifierDescr oldIdentifier = variable.getIdentifier();
            variable.getElements().addMemberBefore(oldIdentifier, newIdentifier);
            variable.getElements().remove(oldIdentifier);
            updateAccessors = true;
        }
        if (driverUtils.isManagedType(fieldDescr.getType(), classTypeResolver) && !driverUtils.equalsType(fieldDescr.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver)) {
            String newClassName = property.isMultiple() ? property.getBag() + "<" + property.getClassName() + ">" : property.getClassName();
            TypeDescr newType = descriptorFactory.createTypeDescr(newClassName);
            oldType = targetFieldDescr.getType();
            targetFieldDescr.getElements().addMemberBefore(oldType, newType);
            targetFieldDescr.getElements().remove(oldType);
            updateAccessors = true;
        }
        this.updateClassOrFieldAnnotations(classDescr, fieldDescr, property.getAnnotations(), classTypeResolver);
        if (updateAccessors) {
            boolean removed = false;
            String oldClassName = oldType.isClassOrInterfaceType() ? oldType.getClassOrInterfaceType().getClassName() : oldType.getPrimitiveType().getName();
            String accessorName = genTools.toJavaGetter(fieldName, oldClassName);
            logger.debug("Removing getter: " + accessorName + " for field: " + fieldName);
            this.removeMethod(classDescr, accessorName);
            accessorName = genTools.toJavaSetter(fieldName);
            logger.debug("Removing setter: " + accessorName + " for field: " + fieldName);
            this.removeMethod(classDescr, accessorName);
            String methodSource = genTools.indent(engine.generateFieldGetterString(context, property));
            MethodDescr methodDescr = descriptorFactory.createMethodDescr(methodSource, true);
            classDescr.addMethod(methodDescr);
            methodSource = genTools.indent(engine.generateFieldSetterString(context, property));
            methodDescr = descriptorFactory.createMethodDescr(methodSource, true);
            classDescr.addMethod(methodDescr);
        }
    }

    public void createField(ClassDescr classDescr, ObjectProperty property) throws Exception {
        DescriptorFactory descriptorFactory = DescriptorFactoryImpl.getInstance();
        GenerationContext generationContext = new GenerationContext(null);
        GenerationTools genTools = new GenerationTools();
        try {
            GenerationEngine engine = GenerationEngine.getInstance();
            String fieldSource = genTools.indent(engine.generateCompleteFieldString(generationContext, property));
            FieldDescr fieldDescr = descriptorFactory.createFieldDescr(fieldSource, true);
            classDescr.addField(fieldDescr);
            String methodSource = genTools.indent(engine.generateFieldGetterString(generationContext, property));
            MethodDescr methodDescr = descriptorFactory.createMethodDescr(methodSource, true);
            String methodName = genTools.toJavaGetter(property.getName(), property.getClassName());
            this.removeMethod(classDescr, methodName);
            classDescr.addMethod(methodDescr);
            methodSource = genTools.indent(engine.generateFieldSetterString(generationContext, property));
            methodDescr = descriptorFactory.createMethodDescr(methodSource, true);
            methodName = genTools.toJavaSetter(property.getName());
            this.removeMethod(classDescr, methodName);
            classDescr.addMethod(methodDescr);
        }
        catch (Exception e) {
            logger.error("Field: " + property.getName() + " couldn't be created.", (Throwable)e);
            throw e;
        }
    }

    private void removeMethod(ClassDescr classDescr, String methodName) {
        logger.debug("Removing method: " + methodName + ", form class: " + classDescr.getIdentifier().getIdentifier());
        MethodDescr methodDescr = classDescr.getMethod(methodName);
        if (methodDescr != null) {
            this.adjustFieldOrMethodIndent(classDescr, methodDescr);
            classDescr.getElements().remove(methodDescr);
        } else {
            logger.debug("Method method: " + methodName + " not exists for class: " + classDescr.getIdentifier().getIdentifier());
        }
    }

    public void removeField(ClassDescr classDescr, String fieldName) {
        logger.debug("Removing field: " + fieldName + ", from class: " + classDescr.getIdentifier().getIdentifier());
        FieldDescr fieldDescr = classDescr.getField(fieldName);
        boolean removed = false;
        GenerationTools genTools = new GenerationTools();
        if (fieldDescr != null) {
            String fieldType = fieldDescr.getType().isClassOrInterfaceType() ? fieldDescr.getType().getClassOrInterfaceType().getClassName() : fieldDescr.getType().getPrimitiveType().getName();
            FieldDescr field = classDescr.getField(fieldName);
            this.adjustFieldOrMethodIndent(classDescr, field);
            removed = classDescr.removeField(fieldName);
            if (removed) {
                logger.debug("field: " + fieldName + " was removed.");
            }
            String accessorName = genTools.toJavaGetter(fieldName, fieldType);
            logger.debug("Removing getter: " + accessorName + " for field: " + fieldName);
            this.removeMethod(classDescr, accessorName);
            accessorName = genTools.toJavaSetter(fieldName);
            logger.debug("Removing setter: " + accessorName + " for field: " + fieldName);
            this.removeMethod(classDescr, accessorName);
        } else {
            logger.debug("Field field: " + fieldName + " was not found in class: " + classDescr.getIdentifier().getIdentifier());
        }
    }

    private void adjustTokenIndent(ElementDescriptor parent, ElementDescriptor element, String[] indentationOptions) {
        TextTokenElementDescr textToken;
        String content;
        ElementDescriptor sibling;
        int index = parent.getElements().indexOf(element);
        if (index > 0 && (sibling = parent.getElements().get(index - 1)) instanceof TextTokenElementDescr && (content = (textToken = (TextTokenElementDescr)sibling).getSourceBuffer().substring(textToken.getStart(), textToken.getStop() + 1)) != null && content.length() > 0) {
            for (int i = 0; i < indentationOptions.length; ++i) {
                if (!content.endsWith(indentationOptions[i])) continue;
                int newStop = textToken.getStop() - indentationOptions[i].length();
                if (newStop < textToken.getStart()) {
                    parent.getElements().remove(sibling);
                    break;
                }
                textToken.setStop(newStop);
                break;
            }
        }
    }

    private String copyFieldVariableToString(FieldDescr fieldDescr, String name) {
        StringBuilder newFieldStr = new StringBuilder();
        VariableDeclarationDescr variable = fieldDescr.getVariableDeclaration(name);
        boolean first = true;
        if (fieldDescr.getModifiers() != null) {
            for (ModifierDescr modifierDescr : fieldDescr.getModifiers().getModifiers()) {
                if (!first) {
                    newFieldStr.append(" ");
                }
                newFieldStr.append(modifierDescr.getName());
                first = false;
            }
        }
        if (fieldDescr.getType().isPrimitiveType()) {
            if (!first) {
                newFieldStr.append(" ");
            }
            newFieldStr.append(fieldDescr.getType().getPrimitiveType().getName());
        } else {
            if (!first) {
                newFieldStr.append(" ");
            }
            newFieldStr.append(fieldDescr.getType().getClassOrInterfaceType().getClassName());
        }
        newFieldStr.append(" ");
        newFieldStr.append(variable.getIdentifier().getIdentifier());
        for (int i = 0; i < variable.getDimensionsCount(); ++i) {
            newFieldStr.append("[]");
        }
        if (variable.getVariableInitializer() != null) {
            newFieldStr.append(" = ");
            newFieldStr.append(variable.getVariableInitializer().getInitializerExpr());
        }
        newFieldStr.append(";");
        return newFieldStr.toString();
    }

    private void adjustModifiersIndent(ElementDescriptor parent, ModifierListDescr modifierListDescr) {
        this.adjustTokenIndent(parent, modifierListDescr, modifiersIndentationOptions);
    }

    private void adjustFieldOrMethodIndent(ClassDescr classDescr, ElementDescriptor fieldOrMethod) {
        this.adjustTokenIndent(classDescr, fieldOrMethod, indentationOptions);
    }
}

