/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.drools.core.base.ClassTypeResolver;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaTypeInfoImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.DriverResult;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverError;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverListener;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.driver.TypeInfoResult;
import org.kie.workbench.common.services.datamodeller.driver.impl.DefaultJavaRoasterModelAnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.CommonAnnotations;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.PositionAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.util.DataModelUtils;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.FileUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class JavaRoasterModelDriver
implements ModelDriver {
    private static final Logger logger = LoggerFactory.getLogger(JavaRoasterModelDriver.class);
    IOService ioService;
    boolean recursiveScan;
    Path javaRootPath;
    private ClassLoader classLoader;
    private List<AnnotationDefinition> configuredAnnotations = new ArrayList<AnnotationDefinition>();
    private Map<String, AnnotationDefinition> configuredAnnotationsIndex = new HashMap<String, AnnotationDefinition>();
    private Map<String, AnnotationDriver> annotationDrivers = new HashMap<String, AnnotationDriver>();
    private static final String DATA_OBJECT_LOAD_ERROR = "It was not possible to create or load DataObject: \"{0}\" .";
    private static final String ANNOTATION_LOAD_ERROR = "It was not possible to create or load a DataObject or Field annotation for annotation class name: \"{0}\" .";
    private static final String DATA_OBJECT_FIELD_LOAD_ERROR = "It was not possible to create or load field: \"{0}\" for DataObject: \"{1}\" .";
    private static final String MODEL_LOAD_GENERIC_ERROR = "Unexpected error was produced when a DataModel was being loaded from the following path: \"{0}\" .";
    private static final String GENERIC_ERROR = "Unexpected error was produced.";

    public JavaRoasterModelDriver() {
        this.configuredAnnotations.addAll(CommonAnnotations.getCommonAnnotations());
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultJavaRoasterModelAnnotationDriver());
            this.configuredAnnotationsIndex.put(annotationDefinition.getClassName(), annotationDefinition);
        }
    }

    public JavaRoasterModelDriver(IOService ioService, Path javaRootPath, boolean recursiveScan, ClassLoader classLoader) {
        this();
        this.ioService = ioService;
        this.recursiveScan = recursiveScan;
        this.javaRootPath = javaRootPath;
        this.classLoader = classLoader;
    }

    @Override
    public List<AnnotationDefinition> getConfiguredAnnotations() {
        return this.configuredAnnotations;
    }

    @Override
    public AnnotationDefinition getConfiguredAnnotation(String annotationClassName) {
        return this.configuredAnnotationsIndex.get(annotationClassName);
    }

    @Override
    public AnnotationDriver getAnnotationDriver(String annotationClassName) {
        return this.annotationDrivers.get(annotationClassName);
    }

    @Override
    public void generateModel(DataModel dataModel, ModelDriverListener generationListener) throws Exception {
    }

    @Override
    public ModelDriverResult loadModel() throws ModelDriverException {
        ModelDriverResult result = new ModelDriverResult();
        DataModel dataModel = this.createModel();
        result.setDataModel(dataModel);
        ArrayList<Path> rootPaths = new ArrayList<Path>();
        rootPaths.add(this.javaRootPath);
        Collection<FileUtils.ScanResult> scanResults = FileUtils.getInstance().scan(this.ioService, rootPaths, ".java", true);
        if (scanResults != null) {
            for (FileUtils.ScanResult scanResult : scanResults) {
                logger.debug("Starting file loading into model, file: " + scanResult.getFile());
                String fileContent = this.ioService.readAllString(scanResult.getFile());
                if (fileContent == null || "".equals(fileContent)) {
                    logger.debug("file: " + scanResult.getFile() + " is empty.");
                    continue;
                }
                try {
                    JavaType javaType = Roaster.parse((String)fileContent);
                    if (javaType.isClass()) {
                        if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                            this.addSyntaxErrors(result, scanResult.getFile(), javaType.getSyntaxErrors());
                            continue;
                        }
                        try {
                            Pair<DataObject, List<ObjectProperty>> pair = this.parseDataObject((JavaClassSource)javaType);
                            if (pair.getK1() == null) continue;
                            dataModel.addDataObject(pair.getK1());
                            result.setClassPath(pair.getK1().getClassName(), scanResult.getFile());
                            result.setUnmanagedProperties(pair.getK1().getClassName(), pair.getK2());
                        }
                        catch (ModelDriverException e) {
                            logger.error("An error was produced when file: " + scanResult.getFile() + " was being loaded into a DataObject.", (Throwable)e);
                            this.addModelDriverError(result, scanResult.getFile(), e);
                        }
                        continue;
                    }
                    logger.debug("No Class definition was found for file: " + scanResult.getFile() + ", it will be skipped.");
                }
                catch (Exception e) {
                    logger.error(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), (Throwable)e);
                    throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), e);
                }
            }
        }
        return result;
    }

    public ModelDriverResult loadDataObject(String source, Path path) throws ModelDriverException {
        ModelDriverResult result = new ModelDriverResult();
        DataModel dataModel = this.createModel();
        result.setDataModel(dataModel);
        if (source == null || "".equals(source)) {
            logger.debug("source: " + source + " is empty.");
            return result;
        }
        try {
            JavaType javaType = Roaster.parse((String)source);
            if (javaType.isClass()) {
                if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                    this.addSyntaxErrors(result, path, javaType.getSyntaxErrors());
                } else {
                    try {
                        Pair<DataObject, List<ObjectProperty>> pair = this.parseDataObject((JavaClassSource)javaType);
                        dataModel.addDataObject(pair.getK1());
                        result.setClassPath(pair.getK1().getClassName(), path);
                        result.setUnmanagedProperties(pair.getK1().getClassName(), pair.getK2());
                    }
                    catch (ModelDriverException e) {
                        logger.error("An error was produced when source: " + source + " was being loaded into a DataObject.", (Throwable)e);
                        this.addModelDriverError(result, path, e);
                    }
                }
            } else {
                logger.debug("No Class definition was found for source: " + source + ", it will be skipped.");
            }
        }
        catch (Exception e) {
            logger.error(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, this.javaRootPath.toUri()), e);
        }
        return result;
    }

    public TypeInfoResult loadJavaTypeInfo(String source) throws ModelDriverException {
        TypeInfoResult result = new TypeInfoResult();
        if (source == null || "".equals(source)) {
            logger.debug("source: " + source + " is empty.");
            return result;
        }
        try {
            JavaType javaType = Roaster.parse((String)source);
            if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                this.addSyntaxErrors(result, null, javaType.getSyntaxErrors());
            } else {
                JavaTypeInfoImpl typeInfo = new JavaTypeInfoImpl();
                result.setTypeInfo(typeInfo);
                typeInfo.setName(javaType.getName());
                typeInfo.setPackageName(javaType.getPackage());
                typeInfo.setAnnotation(javaType.isAnnotation());
                typeInfo.setClass(javaType.isClass());
                typeInfo.setEnum(javaType.isEnum());
                typeInfo.setInterface(javaType.isInterface());
                typeInfo.setPackagePrivate(javaType.isPackagePrivate());
                typeInfo.setPrivate(javaType.isPrivate());
                typeInfo.setProtected(javaType.isProtected());
                typeInfo.setInterface(javaType.isInterface());
            }
        }
        catch (Exception e) {
            logger.error(this.errorMessage(GENERIC_ERROR, e));
            throw new ModelDriverException(this.errorMessage(MODEL_LOAD_GENERIC_ERROR, new Object[0]), e);
        }
        return result;
    }

    private void addModelDriverError(ModelDriverResult result, Path file, ModelDriverException e) {
        StringBuilder message = new StringBuilder();
        message.append(e.getMessage());
        Throwable cause = e.getCause();
        while (cause != null) {
            message.append(" : ");
            message.append(cause.getMessage());
            if (cause instanceof ModelDriverException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        ModelDriverError error = new ModelDriverError(message.toString(), file);
        result.addError(error);
    }

    private void addSyntaxErrors(DriverResult result, Path file, List<SyntaxError> syntaxErrors) {
        for (SyntaxError syntaxError : syntaxErrors) {
            ModelDriverError error = new ModelDriverError(syntaxError.getDescription(), file);
            error.setLine(syntaxError.getLine());
            error.setColumn(syntaxError.getColumn());
            result.addError(error);
        }
    }

    private void addError(ModelDriverResult result, Path file, Exception e) {
        ModelDriverError error = new ModelDriverError(e.getMessage(), file);
        result.addError(error);
    }

    @Override
    public DataModel createModel() {
        return ModelFactoryImpl.getInstance().newModel();
    }

    private Pair<DataObject, List<ObjectProperty>> parseDataObject(JavaClassSource javaClassSource) throws ModelDriverException {
        DriverUtils driverUtils = DriverUtils.getInstance();
        String className = javaClassSource.getName();
        String packageName = javaClassSource.getPackage();
        String qualifiedName = NamingUtils.createQualifiedName(packageName, className);
        if (logger.isDebugEnabled()) {
            logger.debug("Building DataObject for, packageName: " + packageName + ", className: " + className);
        }
        ClassTypeResolver classTypeResolver = DriverUtils.getInstance().createClassTypeResolver(javaClassSource, this.classLoader);
        int modifiers = driverUtils.buildModifierRepresentation(javaClassSource);
        DataObjectImpl dataObject = new DataObjectImpl(packageName, className, modifiers);
        ArrayList<ObjectPropertyImpl> unmanagedProperties = new ArrayList<ObjectPropertyImpl>();
        try {
            List fields;
            List annotations;
            if (javaClassSource.getSuperType() != null) {
                String superClass = this.resolveTypeName(classTypeResolver, javaClassSource.getSuperType());
                dataObject.setSuperClassName(superClass);
            }
            if ((annotations = javaClassSource.getAnnotations()) != null) {
                for (AnnotationSource annotation : annotations) {
                    this.addDataObjectAnnotation(dataObject, annotation, classTypeResolver);
                }
            }
            if ((fields = javaClassSource.getFields()) != null) {
                for (FieldSource field : fields) {
                    if (driverUtils.isManagedType(field.getType(), classTypeResolver)) {
                        this.addProperty(dataObject, (FieldSource<JavaClassSource>)field, classTypeResolver);
                        continue;
                    }
                    logger.debug("field: " + field + "with fieldName: " + field.getName() + " won't be loaded by the diver because type: " + field.getType().getName() + " isn't a managed type.");
                    unmanagedProperties.add(new ObjectPropertyImpl(field.getName(), field.getType().toString(), false, driverUtils.buildModifierRepresentation((Member<?>)field)));
                }
            }
            return new Pair<DataObject, List<ObjectProperty>>(dataObject, unmanagedProperties);
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), e);
        }
        catch (ModelDriverException e) {
            logger.error(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_LOAD_ERROR, qualifiedName), e);
        }
    }

    private boolean isManagedProperty(ObjectProperty property) {
        return !property.isStatic() && !property.isFinal();
    }

    private List<ObjectProperty> filterManagedProperties(DataObject dataObject) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        for (ObjectProperty property : dataObject.getProperties().values()) {
            if (!this.isManagedProperty(property)) continue;
            result.add(property);
        }
        return result;
    }

    private ObjectProperty addProperty(DataObject dataObject, FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        ObjectProperty property = this.parseProperty(field, classTypeResolver);
        dataObject.addProperty(property);
        return property;
    }

    public ObjectProperty parseProperty(FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        ObjectPropertyImpl property;
        boolean multiple = false;
        String bag = null;
        DriverUtils driverUtils = DriverUtils.getInstance();
        int modifiers = driverUtils.buildModifierRepresentation((Member<?>)field);
        try {
            String className;
            Type type = field.getType();
            if (type.isPrimitive()) {
                className = type.getName();
            } else if (driverUtils.isSimpleClass(type)) {
                className = this.resolveTypeName(classTypeResolver, type.getName());
            } else {
                multiple = true;
                Type elementsType = (Type)type.getTypeArguments().get(0);
                className = this.resolveTypeName(classTypeResolver, elementsType.getName());
                bag = this.resolveTypeName(classTypeResolver, type.getName());
            }
            property = new ObjectPropertyImpl(field.getName(), className, multiple, bag, modifiers);
            List annotations = field.getAnnotations();
            if (annotations != null) {
                for (AnnotationSource annotation : annotations) {
                    this.addPropertyAnnotation(property, annotation, classTypeResolver);
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(DATA_OBJECT_FIELD_LOAD_ERROR, field.getName(), ((JavaClassSource)field.getOrigin()).getName()), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(DATA_OBJECT_FIELD_LOAD_ERROR, field.getName(), ((JavaClassSource)field.getOrigin()).getName()), e);
        }
        return property;
    }

    public List<ObjectProperty> parseManagedTypesProperties(JavaClassSource javaClassSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        List fields = javaClassSource.getFields();
        DriverUtils driverUtils = DriverUtils.getInstance();
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        for (FieldSource field : fields) {
            if (driverUtils.isManagedType(field.getType(), classTypeResolver)) {
                ObjectProperty property = this.parseProperty((FieldSource<JavaClassSource>)field, classTypeResolver);
                properties.add(property);
                continue;
            }
            logger.debug("field: " + field + "with fieldName: " + field.getName() + " won't be loaded by the diver because type: " + field.getType().getName() + " isn't a managed type.");
        }
        return properties;
    }

    private void addDataObjectAnnotation(DataObject dataObject, AnnotationSource annotationSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = this.createAnnotation(annotationSource, classTypeResolver);
        if (annotation != null) {
            dataObject.addAnnotation(annotation);
        }
    }

    private void addPropertyAnnotation(ObjectProperty property, AnnotationSource annotationSource, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        org.kie.workbench.common.services.datamodeller.core.Annotation annotation = this.createAnnotation(annotationSource, classTypeResolver);
        if (annotation != null) {
            property.addAnnotation(annotation);
        }
    }

    private org.kie.workbench.common.services.datamodeller.core.Annotation createAnnotation(AnnotationSource annotationToken, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        try {
            String annotationClassName = this.resolveTypeName(classTypeResolver, annotationToken.getName());
            AnnotationDefinition annotationDefinition = this.getConfiguredAnnotation(annotationClassName);
            org.kie.workbench.common.services.datamodeller.core.Annotation annotation = null;
            if (annotationDefinition != null) {
                AnnotationDriver annotationDriver = this.getAnnotationDriver(annotationDefinition.getClassName());
                if (annotationDriver != null) {
                    annotation = annotationDriver.buildAnnotation(annotationDefinition, annotationToken);
                } else {
                    logger.warn("AnnotationDriver for annotation: " + annotationToken.getName() + " is not configured for this ModelDriver driver");
                }
            } else {
                logger.warn("Annotation: " + annotationToken.getName() + " is not configured for this ModelDriver driver.");
            }
            return annotation;
        }
        catch (ClassNotFoundException e) {
            logger.error(this.errorMessage(ANNOTATION_LOAD_ERROR, annotationToken.getName()), (Throwable)e);
            throw new ModelDriverException(this.errorMessage(ANNOTATION_LOAD_ERROR, annotationToken.getName()), e);
        }
    }

    private String resolveTypeName(ClassTypeResolver classTypeResolver, String name) throws ClassNotFoundException {
        try {
            if (NamingUtils.isQualifiedName(name)) {
                return name;
            }
            return classTypeResolver.getFullTypeName(name);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class could not be resolved for name: " + name, (Throwable)e);
            throw e;
        }
    }

    public void updateImports(JavaClassSource javaClassSource, Map<String, String> renamedClasses, List<String> deletedClasses) {
        String currentPackage;
        List imports = javaClassSource.getImports();
        String string = currentPackage = javaClassSource.isDefaultPackage() ? null : javaClassSource.getPackage();
        if (imports != null) {
            for (Import currentImport : imports) {
                if (currentImport.isWildcard() || currentImport.isStatic()) continue;
                String newClassName = renamedClasses.get(currentImport.getQualifiedName());
                if (newClassName != null) {
                    javaClassSource.removeImport(currentImport);
                    if (StringUtils.equals((String)currentPackage, (String)NamingUtils.extractPackageName(newClassName))) continue;
                    javaClassSource.addImport(newClassName);
                    continue;
                }
                if (!deletedClasses.contains(currentImport.getQualifiedName())) continue;
                javaClassSource.removeImport(currentImport);
            }
        }
    }

    public boolean updatePackage(JavaClassSource javaClassSource, String packageName) {
        String oldPackageName = javaClassSource.getPackage();
        if (packageName == null) {
            javaClassSource.setDefaultPackage();
        } else {
            javaClassSource.setPackage(packageName);
        }
        return StringUtils.equals((String)oldPackageName, (String)packageName);
    }

    public boolean updateClassName(JavaClassSource javaClassSource, String name) throws Exception {
        String oldName = javaClassSource.getName();
        javaClassSource.setName(name);
        return StringUtils.equals((String)oldName, (String)name);
    }

    public boolean updateSuperClassName(JavaClassSource javaClassSource, String superClassName, ClassTypeResolver classTypeResolver) throws Exception {
        String oldSuperClassName;
        String string = oldSuperClassName = javaClassSource.getSuperType() != null ? this.resolveTypeName(classTypeResolver, javaClassSource.getSuperType()) : null;
        if (!StringUtils.equals((String)oldSuperClassName, (String)superClassName)) {
            javaClassSource.setSuperType(superClassName);
            return true;
        }
        return false;
    }

    public void updateAnnotations(AnnotationTargetSource annotationTargetSource, List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations, ClassTypeResolver classTypeResolver) throws Exception {
        JavaRoasterModelDriver driver = new JavaRoasterModelDriver();
        List currentAnnotations = annotationTargetSource.getAnnotations();
        if (currentAnnotations != null) {
            for (AnnotationSource currentAnnotation : currentAnnotations) {
                String currentAnnotationClassName = this.resolveTypeName(classTypeResolver, currentAnnotation.getName());
                if (driver.getConfiguredAnnotation(currentAnnotationClassName) == null) continue;
                annotationTargetSource.removeAnnotation((Annotation)currentAnnotation);
            }
        }
        if (annotations != null) {
            for (org.kie.workbench.common.services.datamodeller.core.Annotation annotation : annotations) {
                this.addAnnotation(annotationTargetSource, annotation);
            }
        }
    }

    public AnnotationSource<?> addAnnotation(AnnotationTargetSource annotationTargetSource, org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        JavaRoasterModelDriver driver = new JavaRoasterModelDriver();
        AnnotationSource newAnnotationSource = annotationTargetSource.addAnnotation();
        newAnnotationSource.setName(annotation.getClassName());
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        if (annotationDefinition == null) {
            annotationDefinition = driver.getConfiguredAnnotation(annotation.getClassName());
        }
        if (annotationDefinition == null) {
            logger.warn("Annotation: " + annotation.getClassName() + " is not configured for this driver");
        } else if (!annotationDefinition.isMarker()) {
            for (AnnotationMemberDefinition memberDefinition : annotationDefinition.getAnnotationMembers()) {
                Object value = annotation.getValue(memberDefinition.getName());
                if (value == null) continue;
                this.addMemberValue(newAnnotationSource, memberDefinition, value);
            }
        }
        return newAnnotationSource;
    }

    public void addMemberValue(AnnotationSource<?> annotationSource, AnnotationMemberDefinition memberDefinition, Object value) {
        StringBuilder strValue = new StringBuilder();
        GenerationTools genTools = new GenerationTools();
        if (memberDefinition.isEnum()) {
            strValue.append(memberDefinition.getClassName());
            strValue.append(".");
            strValue.append(value);
            annotationSource.setLiteralValue(memberDefinition.getName(), strValue.toString());
        } else if (memberDefinition.isString()) {
            annotationSource.setStringValue(memberDefinition.getName(), value != null ? value.toString() : null);
        } else if (memberDefinition.isPrimitiveType()) {
            if (Character.class.getName().equals(memberDefinition.getClassName())) {
                annotationSource.setLiteralValue(memberDefinition.getName(), value.toString());
            } else if (Long.class.getName().equals(memberDefinition.getClassName())) {
                strValue.append(value.toString());
                strValue.append("L");
                annotationSource.setLiteralValue(memberDefinition.getName(), strValue.toString());
            } else if (Float.class.getName().equals(memberDefinition.getClassName())) {
                strValue.append(value.toString());
                strValue.append("f");
                annotationSource.setLiteralValue(memberDefinition.getName(), strValue.toString());
            } else if (Double.class.getName().equals(memberDefinition.getClassName())) {
                strValue.append(value.toString());
                strValue.append("d");
                annotationSource.setLiteralValue(memberDefinition.getName(), strValue.toString());
            } else {
                annotationSource.setLiteralValue(memberDefinition.getName(), value.toString());
            }
        }
    }

    public void createField(JavaClassSource javaClassSource, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationContext generationContext = new GenerationContext(null);
        GenerationTools genTools = new GenerationTools();
        try {
            GenerationEngine engine = GenerationEngine.getInstance();
            String fieldSource = genTools.indent(engine.generateCompleteFieldString(generationContext, property));
            javaClassSource.addField(fieldSource);
            String methodSource = genTools.indent(engine.generateFieldGetterString(generationContext, property));
            String methodName = genTools.toJavaGetter(property.getName(), property.getClassName());
            this.removeMethodByParamsClassName(javaClassSource, methodName, new String[0]);
            javaClassSource.addMethod(methodSource);
            methodSource = genTools.indent(engine.generateFieldSetterString(generationContext, property));
            methodName = genTools.toJavaSetter(property.getName());
            this.removeMethodByParamsClassName(javaClassSource, methodName, property.getClassName());
            javaClassSource.addMethod(methodSource);
        }
        catch (Exception e) {
            logger.error("Field: " + property.getName() + " couldn't be created.", (Throwable)e);
            throw e;
        }
    }

    public void updateField(JavaClassSource javaClassSource, String fieldName, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationTools genTools = new GenerationTools();
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        DriverUtils driverUtils = DriverUtils.getInstance();
        boolean updateAccessors = false;
        FieldSource field = javaClassSource.getField(fieldName);
        Type oldType = field.getType();
        if (this.hasChangedToCollectionType((FieldSource<JavaClassSource>)field, property, classTypeResolver)) {
            this.updateCollectionField(javaClassSource, fieldName, property, classTypeResolver);
        } else {
            if (!fieldName.equals(property.getName())) {
                field.setName(property.getName());
                updateAccessors = true;
            }
            if (driverUtils.isManagedType(field.getType(), classTypeResolver) && !driverUtils.equalsType(field.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver)) {
                String newClassName = property.getClassName();
                field.setType(newClassName);
                if (field.getLiteralInitializer() != null) {
                    if (NamingUtils.isPrimitiveTypeId(newClassName)) {
                        this.setPrimitiveTypeDefaultInitializer(field, newClassName);
                    } else {
                        field.setLiteralInitializer(null);
                    }
                }
                updateAccessors = true;
            }
            this.updateAnnotations((AnnotationTargetSource)field, property.getAnnotations(), classTypeResolver);
            if (updateAccessors) {
                Class oldClass = classTypeResolver.resolveType(oldType.getName());
                String oldClassName = oldClass.getName();
                String accessorName = genTools.toJavaGetter(fieldName, oldClassName);
                this.removeMethodByParamsClass(javaClassSource, accessorName, new Class[0]);
                accessorName = genTools.toJavaSetter(fieldName);
                this.removeMethodByParamsClass(javaClassSource, accessorName, oldClass);
                String methodSource = genTools.indent(engine.generateFieldGetterString(context, property));
                javaClassSource.addMethod(methodSource);
                methodSource = genTools.indent(engine.generateFieldSetterString(context, property));
                javaClassSource.addMethod(methodSource);
            }
        }
    }

    private void updateCollectionField(JavaClassSource javaClassSource, String fieldName, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        GenerationTools genTools = new GenerationTools();
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationContext context = new GenerationContext(null);
        boolean updateAccessors = true;
        FieldSource currentField = javaClassSource.getField(fieldName);
        Type currentType = currentField.getType();
        StringBuilder fieldSource = new StringBuilder();
        List annotations = currentField.getAnnotations();
        if (annotations != null) {
            for (AnnotationSource annotation : annotations) {
                if (this.isManagedAnnotation(annotation, classTypeResolver)) continue;
                fieldSource.append(annotation.toString());
                fieldSource.append("\n");
            }
        }
        fieldSource.append(engine.generateCompleteFieldString(context, property));
        javaClassSource.removeField((Field)currentField);
        javaClassSource.addField(fieldSource.toString());
        if (updateAccessors) {
            Class oldClass = classTypeResolver.resolveType(currentType.getName());
            String oldClassName = oldClass.getName();
            String accessorName = genTools.toJavaGetter(fieldName, oldClassName);
            this.removeMethodByParamsClass(javaClassSource, accessorName, new Class[0]);
            accessorName = genTools.toJavaSetter(fieldName);
            this.removeMethodByParamsClass(javaClassSource, accessorName, oldClass);
            String methodSource = genTools.indent(engine.generateFieldGetterString(context, property));
            javaClassSource.addMethod(methodSource);
            methodSource = genTools.indent(engine.generateFieldSetterString(context, property));
            javaClassSource.addMethod(methodSource);
        }
    }

    private boolean hasChangedToCollectionType(FieldSource<JavaClassSource> field, ObjectProperty property, ClassTypeResolver classTypeResolver) throws Exception {
        DriverUtils driverUtils = DriverUtils.getInstance();
        return driverUtils.isManagedType(field.getType(), classTypeResolver) && !driverUtils.equalsType(field.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver) && property.isMultiple();
    }

    public void updateConstructors(JavaClassSource javaClassSource, DataObject dataObject, List<MethodSource<JavaClassSource>> allFieldsConstructorCandidates, List<MethodSource<JavaClassSource>> keyFieldsConstructorCandidates, List<MethodSource<JavaClassSource>> positionFieldsConstructorCandidates, ClassTypeResolver classTypeResolver) throws Exception {
        String keyFieldsConstructorSource;
        String positionFieldsConstructorSource;
        String allFieldsConstructorSource;
        MethodSource newConstructor;
        GenerationContext generationContext = new GenerationContext(null);
        GenerationEngine engine = GenerationEngine.getInstance();
        GenerationTools genTools = new GenerationTools();
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        List<MethodSource<JavaClassSource>> currentAllFieldsConstructors = modelDriver.filterGeneratedConstructors(allFieldsConstructorCandidates);
        List<MethodSource<JavaClassSource>> currentKeyFieldsConstructors = modelDriver.filterGeneratedConstructors(keyFieldsConstructorCandidates);
        List<MethodSource<JavaClassSource>> currentPositionFieldsConstructors = modelDriver.filterGeneratedConstructors(positionFieldsConstructorCandidates);
        if (logger.isDebugEnabled()) {
            logger.debug("allFieldsConstructorCandidates candidates: " + allFieldsConstructorCandidates.size());
            logger.debug(allFieldsConstructorCandidates.size() > 0 ? allFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentAllFieldsConstructors: " + currentAllFieldsConstructors.size());
            logger.debug(currentAllFieldsConstructors.size() > 0 ? currentAllFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("KeyFieldsConstructorCandidates: " + keyFieldsConstructorCandidates.size());
            logger.debug(keyFieldsConstructorCandidates.size() > 0 ? keyFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentKeyFieldsConstructors: " + currentKeyFieldsConstructors.size());
            logger.debug(currentKeyFieldsConstructors.size() > 0 ? currentKeyFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("positionFieldsConstructorCandidates: " + positionFieldsConstructorCandidates.size());
            logger.debug(positionFieldsConstructorCandidates.size() > 0 ? positionFieldsConstructorCandidates.get(0).toString() : "");
            logger.debug("\n\n");
            logger.debug("currentPositionFieldsConstructors: " + currentPositionFieldsConstructors.size());
            logger.debug(currentPositionFieldsConstructors.size() > 0 ? currentPositionFieldsConstructors.get(0).toString() : "");
            logger.debug("\n\n");
        }
        for (MethodSource<JavaClassSource> constructor : currentAllFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        for (MethodSource<JavaClassSource> constructor : currentKeyFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        for (MethodSource<JavaClassSource> constructor : currentPositionFieldsConstructors) {
            javaClassSource.removeMethod(constructor);
        }
        List fields = javaClassSource.getFields();
        if (fields != null && fields.size() > 0) {
            int fileOrder = 0;
            for (FieldSource field : fields) {
                ObjectPropertyImpl objectProperty = (ObjectPropertyImpl)dataObject.getProperties().get(field.getName());
                if (objectProperty != null) {
                    objectProperty.setFileOrder(fileOrder);
                }
                ++fileOrder;
            }
        }
        List<ObjectProperty> allFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterAssignableFields(dataObject));
        List<ObjectProperty> positionFields = DataModelUtils.sortByPosition(DataModelUtils.filterPositionFields(dataObject));
        List<ObjectProperty> keyFields = DataModelUtils.sortByFileOrder(DataModelUtils.filterKeyFields(dataObject));
        boolean needsEmptyConstructor = true;
        boolean needsAllFieldsConstructor = allFields.size() > 0;
        boolean needsPositionFieldsConstructor = positionFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, positionFields) && !DataModelUtils.equalsByFieldType(allFields, positionFields);
        boolean needsKeyFieldsConstructor = keyFields.size() > 0 && !DataModelUtils.equalsByFieldName(allFields, keyFields) && !DataModelUtils.equalsByFieldType(allFields, keyFields) && !DataModelUtils.equalsByFieldName(positionFields, keyFields) && !DataModelUtils.equalsByFieldType(positionFields, keyFields);
        ArrayList<MethodSource> currentConstructors = new ArrayList<MethodSource>();
        MethodSource currentEquals = null;
        MethodSource currentHashCode = null;
        List methods = javaClassSource.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                if (method.isConstructor()) {
                    currentConstructors.add(method);
                    if (method.getParameters() != null && method.getParameters().size() != 0) continue;
                    needsEmptyConstructor = false;
                    continue;
                }
                if (this.isEquals(method)) {
                    currentEquals = method;
                    continue;
                }
                if (!this.isHashCode(method)) continue;
                currentHashCode = method;
            }
        }
        needsAllFieldsConstructor = needsAllFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, allFields, classTypeResolver).size() == 0;
        needsPositionFieldsConstructor = needsPositionFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, positionFields, classTypeResolver).size() == 0;
        boolean bl = needsKeyFieldsConstructor = needsKeyFieldsConstructor && this.findMatchingConstructorsByTypes(javaClassSource, keyFields, classTypeResolver).size() == 0;
        if (currentEquals != null) {
            javaClassSource.removeMethod(currentEquals);
        }
        if (currentHashCode != null) {
            javaClassSource.removeMethod(currentHashCode);
        }
        if (needsEmptyConstructor) {
            String defaultConstructorSource = genTools.indent(engine.generateDefaultConstructorString(generationContext, dataObject));
            newConstructor = javaClassSource.addMethod(defaultConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsAllFieldsConstructor && (allFieldsConstructorSource = genTools.indent(engine.generateAllFieldsConstructorString(generationContext, dataObject))) != null && !allFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(allFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsPositionFieldsConstructor && (positionFieldsConstructorSource = genTools.indent(engine.generatePositionFieldsConstructorString(generationContext, dataObject))) != null && !positionFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(positionFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (needsKeyFieldsConstructor && (keyFieldsConstructorSource = genTools.indent(engine.generateKeyFieldsConstructorString(generationContext, dataObject))) != null && !keyFieldsConstructorSource.trim().isEmpty()) {
            newConstructor = javaClassSource.addMethod(keyFieldsConstructorSource);
            newConstructor.setConstructor(true);
        }
        if (keyFields.size() > 0) {
            String equalsMethodSource = genTools.indent(engine.generateEqualsString(generationContext, dataObject));
            javaClassSource.addMethod(equalsMethodSource);
            String hashCodeMethodSource = genTools.indent(engine.generateHashCodeString(generationContext, dataObject));
            javaClassSource.addMethod(hashCodeMethodSource);
        }
    }

    public void removeField(JavaClassSource javaClassSource, String fieldName, ClassTypeResolver classTypeResolver) throws Exception {
        logger.debug("Removing field: " + fieldName + ", from class: " + javaClassSource.getName());
        GenerationTools genTools = new GenerationTools();
        FieldSource field = javaClassSource.getField(fieldName);
        if (field != null) {
            Class fieldClass = classTypeResolver.resolveType(field.getType().getName());
            String methodName = genTools.toJavaGetter(fieldName, fieldClass.getName());
            this.removeMethodByParamsClass(javaClassSource, methodName, new Class[0]);
            methodName = genTools.toJavaSetter(fieldName);
            this.removeMethodByParamsClass(javaClassSource, methodName, fieldClass);
            javaClassSource.removeField((Field)field);
        } else {
            logger.debug("Field field: " + fieldName + " was not found in class: " + javaClassSource.getName());
        }
    }

    public void removeMethodByParamsClass(JavaClassSource javaClassSource, String methodName, Class<?> ... paramTypes) {
        logger.debug("Removing method: " + methodName + ", form class: " + javaClassSource.getName());
        MethodSource method = javaClassSource.getMethod(methodName, (Class[])paramTypes);
        if (method != null) {
            javaClassSource.removeMethod((Method)method);
            logger.debug("Method method: " + methodName + ", was removed from class: " + javaClassSource.getName());
        } else {
            logger.debug("Method method: " + methodName + " not exists for class: " + javaClassSource.getName());
        }
    }

    public void removeMethodByParamsClassName(JavaClassSource javaClassSource, String methodName, String ... paramTypes) {
        logger.debug("Removing method: " + methodName + ", form class: " + javaClassSource.getName());
        MethodSource method = javaClassSource.getMethod(methodName, paramTypes);
        if (method != null) {
            javaClassSource.removeMethod((Method)method);
            logger.debug("Method method: " + methodName + ", was removed from class: " + javaClassSource.getName());
        } else {
            logger.debug("Method method: " + methodName + " not exists for class: " + javaClassSource.getName());
        }
    }

    public List<MethodSource<JavaClassSource>> findAllFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        return this.findMatchingConstructorsByParameters(javaClassSource, properties, classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findKeyFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        List<ObjectProperty> keyFields = DataModelUtils.filterKeyFields(properties);
        return this.findMatchingConstructorsByParameters(javaClassSource, keyFields, classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findPositionFieldsConstructorCandidates(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        List<ObjectProperty> positionalFields = DataModelUtils.filterPositionFields(properties);
        return this.findMatchingConstructorsByParameters(javaClassSource, DataModelUtils.sortByPosition(positionalFields), classTypeResolver);
    }

    public List<MethodSource<JavaClassSource>> findMatchingConstructorsByParameters(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        List<MethodSource<JavaClassSource>> constructors = this.getConstructors(javaClassSource);
        for (MethodSource<JavaClassSource> constructor : constructors) {
            List parameters = constructor.getParameters();
            if (parameters == null || parameters.size() == 0 || parameters.size() != properties.size()) continue;
            int unmatchedParams = parameters.size();
            int paramIndex = 0;
            for (ParameterSource param : parameters) {
                if (this.paramMatchesWithProperty((ParameterSource<JavaClassSource>)param, properties.get(paramIndex), classTypeResolver)) {
                    --unmatchedParams;
                }
                ++paramIndex;
            }
            if (unmatchedParams != 0) continue;
            result.add(constructor);
        }
        return result;
    }

    public List<MethodSource<JavaClassSource>> findMatchingConstructorsByTypes(JavaClassSource javaClassSource, List<ObjectProperty> properties, ClassTypeResolver classTypeResolver) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        List<MethodSource<JavaClassSource>> constructors = this.getConstructors(javaClassSource);
        for (MethodSource<JavaClassSource> constructor : constructors) {
            ParameterSource param;
            List parameters = constructor.getParameters();
            if (parameters == null || parameters.size() == 0 || parameters.size() != properties.size()) continue;
            int unmatchedParams = parameters.size();
            int paramIndex = 0;
            Iterator i$ = parameters.iterator();
            while (i$.hasNext() && this.paramMatchesWithPropertyType((ParameterSource<JavaClassSource>)(param = (ParameterSource)i$.next()), properties.get(paramIndex), classTypeResolver)) {
                --unmatchedParams;
                ++paramIndex;
            }
            if (unmatchedParams != 0) continue;
            result.add(constructor);
        }
        return result;
    }

    public boolean paramMatchesWithProperty(ParameterSource<JavaClassSource> param, ObjectProperty property, ClassTypeResolver classTypeResolver) {
        if (!param.getName().equals(property.getName())) {
            return false;
        }
        DriverUtils driverUtils = DriverUtils.getInstance();
        try {
            return driverUtils.equalsType(param.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver);
        }
        catch (Exception e) {
            logger.error("An error was produced on parameter matching test with param: " + param.getName() + " and field: " + property.getName(), (Throwable)e);
            return false;
        }
    }

    public boolean paramMatchesWithPropertyType(ParameterSource<JavaClassSource> param, ObjectProperty property, ClassTypeResolver classTypeResolver) {
        DriverUtils driverUtils = DriverUtils.getInstance();
        try {
            return driverUtils.equalsType(param.getType(), property.getClassName(), property.isMultiple(), property.getBag(), classTypeResolver);
        }
        catch (Exception e) {
            logger.error("An error was produced on parameter matching test with param: " + param.getName() + " and field: " + property.getName(), (Throwable)e);
            return false;
        }
    }

    public List<MethodSource<JavaClassSource>> filterGeneratedConstructors(List<MethodSource<JavaClassSource>> constructors) {
        ArrayList<MethodSource<JavaClassSource>> result = new ArrayList<MethodSource<JavaClassSource>>();
        if (constructors != null) {
            for (MethodSource<JavaClassSource> constructor : constructors) {
                if (!this.isGeneratedConstructor(constructor)) continue;
                result.add(constructor);
            }
        }
        return result;
    }

    public boolean isGeneratedConstructor(MethodSource<JavaClassSource> constructor) {
        String body;
        if (constructor.isAbstract() || constructor.isStatic() || constructor.isFinal()) {
            return false;
        }
        if (!constructor.isPublic()) {
            return false;
        }
        if (constructor.getAnnotations() != null && constructor.getAnnotations().size() > 0) {
            return false;
        }
        List parameters = constructor.getParameters();
        ArrayList expectedBody = new ArrayList();
        ArrayList<String> expectedLines = new ArrayList<String>();
        if (parameters != null) {
            for (ParameterSource param : parameters) {
                if (param.getAnnotations() != null && param.getAnnotations().size() > 0) {
                    return false;
                }
                String expectedLine = "this." + param.getName() + "=" + param.getName() + ";";
                expectedLines.add(expectedLine);
            }
        }
        if ((body = constructor.getBody()) == null || (body = body.trim()).isEmpty()) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(body));
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                if (++lineNumber > expectedLines.size()) {
                    return false;
                }
                if (line.trim().equals(expectedLines.get(lineNumber - 1))) continue;
                return false;
            }
            return lineNumber == expectedLines.size();
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<MethodSource<JavaClassSource>> getConstructors(JavaClassSource javaClassSource) {
        ArrayList<MethodSource<JavaClassSource>> constructors = new ArrayList<MethodSource<JavaClassSource>>();
        List methods = javaClassSource.getMethods();
        if (methods != null) {
            for (MethodSource method : methods) {
                if (!method.isConstructor()) continue;
                constructors.add((MethodSource<JavaClassSource>)method);
            }
        }
        return constructors;
    }

    public boolean isManagedField(FieldSource<JavaClassSource> field, ClassTypeResolver classTypeResolver) throws Exception {
        if (!field.isFinal() && !field.isStatic()) {
            return DriverUtils.getInstance().isManagedType(field.getType(), classTypeResolver);
        }
        return false;
    }

    public boolean isEquals(MethodSource<?> method) {
        return method.getName().equals("equals") && (method.getParameters() == null || method.getParameters().size() == 1) && method.getReturnType() != null && method.getReturnType().isPrimitive() && "boolean".equals(method.getReturnType().getName());
    }

    public boolean isHashCode(MethodSource<?> method) {
        return method.getName().equals("hashCode") && (method.getParameters() == null || method.getParameters().size() == 0) && method.getReturnType() != null && method.getReturnType().isPrimitive() && "int".equals(method.getReturnType().getName());
    }

    public void setPrimitiveTypeDefaultInitializer(FieldSource<?> field, String primitiveType) {
        if ("byte".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("short".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("int".equals(primitiveType)) {
            field.setLiteralInitializer("0");
        }
        if ("long".equals(primitiveType)) {
            field.setLiteralInitializer("0L");
        }
        if ("float".equals(primitiveType)) {
            field.setLiteralInitializer("0.0f");
        }
        if ("double".equals(primitiveType)) {
            field.setLiteralInitializer("0.0d");
        }
        if ("char".equals(primitiveType)) {
            field.setLiteralInitializer("'\\u0000'");
        }
        if ("boolean".equals(primitiveType)) {
            field.setLiteralInitializer("false");
        }
    }

    public boolean isManagedAnnotation(AnnotationSource<?> annotation, ClassTypeResolver classTypeResolver) throws Exception {
        String annotationClassName = this.resolveTypeName(classTypeResolver, annotation.getName());
        return this.getConfiguredAnnotation(annotationClassName) != null;
    }

    private String errorMessage(String message, Object ... params) {
        return MessageFormat.format(message, params);
    }

    private void verifyPositions(DataObject dataObject, List<PropertyPosition> naturalOrderPositions) {
        HashMap<String, String> availablePositions = new HashMap<String, String>();
        int i = 0;
        List<ObjectProperty> managedProperties = this.filterManagedProperties(dataObject);
        for (ObjectProperty property : managedProperties) {
            availablePositions.put(String.valueOf(i), "");
            ++i;
        }
        boolean recalculate = false;
        for (ObjectProperty property : managedProperties) {
            org.kie.workbench.common.services.datamodeller.core.Annotation position = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            if (position == null) {
                recalculate = true;
                break;
            }
            String value = (String)position.getValue("value");
            if (value == null) continue;
            availablePositions.remove(value.trim());
        }
        ArrayList<PropertyPosition> desiredPositions = new ArrayList<PropertyPosition>();
        if (recalculate || availablePositions.size() > 0) {
            for (PropertyPosition propertyPosition : naturalOrderPositions) {
                org.kie.workbench.common.services.datamodeller.core.Annotation desiredPosition = propertyPosition.property.removeAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
                if (desiredPosition != null) {
                    desiredPositions.add(new PropertyPosition(propertyPosition.property, desiredPosition));
                }
                propertyPosition.property.addAnnotation(propertyPosition.position);
            }
            this.recalculatePositions(dataObject, desiredPositions);
        }
    }

    private void recalculatePositions(DataObject dataObject, List<PropertyPosition> desiredPositions) {
        List<ObjectProperty> properties = this.filterManagedProperties(dataObject);
        for (PropertyPosition desiredPosition : desiredPositions) {
            ObjectProperty property = dataObject.getProperties().get(desiredPosition.property.getName());
            org.kie.workbench.common.services.datamodeller.core.Annotation currentPosition = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            this.recalculatePositions(properties, currentPosition, desiredPosition.position);
        }
    }

    private void recalculatePositions(Collection<ObjectProperty> properties, org.kie.workbench.common.services.datamodeller.core.Annotation oldPositionAnnotaion, org.kie.workbench.common.services.datamodeller.core.Annotation newPositionAnnotation) {
        Integer newPosition;
        Integer oldPosition;
        Integer maxPosition = properties.size() - 1;
        try {
            oldPosition = Integer.parseInt((String)oldPositionAnnotaion.getValue("value"));
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            newPosition = Integer.parseInt((String)newPositionAnnotation.getValue("value"));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition > maxPosition) {
            newPosition = maxPosition;
        }
        if (newPosition == oldPosition) {
            return;
        }
        for (ObjectProperty property : properties) {
            org.kie.workbench.common.services.datamodeller.core.Annotation propertyPositionAnnotation = property.getAnnotation(PositionAnnotationDefinition.getInstance().getClassName());
            int propertyPosition = Integer.parseInt((String)propertyPositionAnnotation.getValue("value"));
            if (newPosition < oldPosition) {
                if (propertyPosition >= newPosition && propertyPosition < oldPosition) {
                    propertyPositionAnnotation.setValue("value", Integer.valueOf(propertyPosition + 1).toString());
                }
            } else if (propertyPosition <= newPosition && propertyPosition > oldPosition) {
                propertyPositionAnnotation.setValue("value", Integer.valueOf(propertyPosition - 1).toString());
            }
            if (propertyPosition != oldPosition) continue;
            propertyPositionAnnotation.setValue("value", newPosition.toString());
        }
    }

    public static class Pair<K, T> {
        K k1;
        T k2;

        public Pair(K k1, T k2) {
            this.k1 = k1;
            this.k2 = k2;
        }

        public K getK1() {
            return this.k1;
        }

        public void setK1(K k1) {
            this.k1 = k1;
        }

        public T getK2() {
            return this.k2;
        }

        public void setK2(T k2) {
            this.k2 = k2;
        }
    }

    public static class ModelFilter {
        boolean includeFields = true;
    }

    static class PropertyPosition {
        ObjectProperty property;
        org.kie.workbench.common.services.datamodeller.core.Annotation position;

        PropertyPosition(ObjectProperty property, org.kie.workbench.common.services.datamodeller.core.Annotation position) {
            this.property = property;
            this.position = position;
        }
    }
}

