/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class NamingUtils {
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String CHAR = "char";
    public static final String BOOLEAN = "boolean";

    public static String extractClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(index + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String extractPackageName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(0, index);
        }
        return null;
    }

    public static List<String> tokenizePackageName(String packageName) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (packageName != null) {
            StringTokenizer st = new StringTokenizer(packageName, ".");
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
        }
        return tokens;
    }

    public static boolean isPrimitiveTypeClass(String className) {
        return Byte.class.getName().equals(className) || Short.class.getName().equals(className) || Integer.class.getName().equals(className) || Long.class.getName().equals(className) || Float.class.getName().equals(className) || Double.class.getName().equals(className) || Character.class.getName().equals(className) || Boolean.class.getName().equals(className);
    }

    public static boolean isPrimitiveTypeId(String type) {
        return BYTE.equals(type) || SHORT.equals(type) || INT.equals(type) || LONG.equals(type) || FLOAT.equals(type) || DOUBLE.equals(type) || CHAR.equals(type) || BOOLEAN.equals(type);
    }

    public static String getClassForPrimitiveTypeId(String type) {
        if (BYTE.equals(type)) {
            return Byte.class.getName();
        }
        if (SHORT.equals(type)) {
            return Short.class.getName();
        }
        if (INT.equals(type)) {
            return Integer.class.getName();
        }
        if (LONG.equals(type)) {
            return Long.class.getName();
        }
        if (FLOAT.equals(type)) {
            return Float.class.getName();
        }
        if (DOUBLE.equals(type)) {
            return Double.class.getName();
        }
        if (CHAR.equals(type)) {
            return Character.class.getName();
        }
        if (BOOLEAN.equals(type)) {
            return Boolean.class.getName();
        }
        return null;
    }

    public static boolean isQualifiedName(String type) {
        String[] tokens = NamingUtils.tokenizeClassName(type);
        return tokens != null && tokens.length > 1;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static String createQualifiedName(String packageName, String className) {
        if (packageName != null && !"".equals(packageName)) {
            return packageName + "." + className;
        }
        return className;
    }
}

