/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.AssetType;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class MigrationPathManager {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private FileSystem fs;
    private static final String[] JAVA_KEYWORDS = new String[]{"package", "import", "class", "public", "protected", "private", "extends", "implements", "return", "if", "while", "for", "do", "else", "try", "new", "void", "catch", "throws", "throw", "static", "final", "break", "continue", "super", "finally", "true", "false", "true;", "false;", "null", "boolean", "int", "char", "long", "float", "double", "short", "abstract", "this", "switch", "assert", "default", "goto", "synchronized", "byte", "case", "enum", "instanceof", "transient", "interface", "strictfp", "volatile", "const", "native"};

    public org.uberfire.backend.vfs.Path generateRootPath() {
        Path _path = this.getFileSystem().getPath("/", new String[0]);
        return Paths.convert((Path)_path);
    }

    public org.uberfire.backend.vfs.Path generatePathForModule(String jcrModuleName) {
        return Paths.convert((Path)this.getFileSystem().getPath("/" + this.escapePathEntry(jcrModuleName), new String[0]));
    }

    public org.uberfire.backend.vfs.Path generatePathForGlobal(Module xmlModule) {
        Path modulePath = this.getFileSystem().getPath("/" + this.escapePathEntry(xmlModule.getNormalizedPackageName()), new String[0]);
        Path assetPath = modulePath.resolve("src/main/resources/" + this.dotToSlash(xmlModule.getNormalizedPackageName()) + "/" + "globals.gdrl");
        return Paths.convert((Path)assetPath);
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module xmlModule, XmlAsset xmlAsset, String extension, boolean hasDSL) {
        String normalizedName = xmlModule.getNormalizedPackageName();
        Path modulePath = this.getFileSystem().getPath("/" + this.escapePathEntry(normalizedName), new String[0]);
        Path assetPath = null;
        assetPath = AssetType.BUSINESS_RULE.equals((Object)xmlAsset.getAssetType()) && !hasDSL ? modulePath.resolve("src/main/resources/" + this.dotToSlash(normalizedName) + "/" + xmlAsset.getName() + ".rdrl") : (AssetType.BUSINESS_RULE.equals((Object)xmlAsset.getAssetType()) && hasDSL ? modulePath.resolve("src/main/resources/" + this.dotToSlash(normalizedName) + "/" + xmlAsset.getName() + ".rdslr") : (AssetType.FUNCTION.equals((Object)xmlAsset.getAssetType()) ? modulePath.resolve("src/main/resources/" + this.dotToSlash(normalizedName) + "/" + xmlAsset.getName() + ".drl") : (AssetType.TEST_SCENARIO.equals((Object)xmlAsset.getAssetType()) ? modulePath.resolve("src/test/resources/" + this.dotToSlash(normalizedName) + "/" + xmlAsset.getName() + "." + extension) : modulePath.resolve("src/main/resources/" + this.dotToSlash(normalizedName) + "/" + xmlAsset.getName() + "." + extension))));
        return Paths.convert((Path)assetPath);
    }

    public org.uberfire.backend.vfs.Path generatePathForAsset(Module xmlModule, XmlAsset xmlAsset, String extension) {
        return this.generatePathForAsset(xmlModule, xmlAsset, extension, false);
    }

    public String escapePathEntry(String pathEntry) {
        pathEntry = pathEntry.replace("/", " slash ");
        pathEntry = this.normalizePackageName(pathEntry);
        return pathEntry;
    }

    public String normalizePackageName(String stringToEscape) {
        String[] nameSplit = stringToEscape.split("\\.");
        StringBuilder normalizedPkgNameBuilder = new StringBuilder();
        for (int j = 0; j < nameSplit.length; ++j) {
            int i = 0;
            if (j > 0 && j < nameSplit.length) {
                normalizedPkgNameBuilder.append(".");
            }
            while (i < JAVA_KEYWORDS.length) {
                if (JAVA_KEYWORDS[i].equals(nameSplit[j])) {
                    normalizedPkgNameBuilder.append("mod_");
                    normalizedPkgNameBuilder.append(nameSplit[j].toLowerCase());
                    break;
                }
                ++i;
            }
            if (i != JAVA_KEYWORDS.length) continue;
            normalizedPkgNameBuilder.append(nameSplit[j].toLowerCase());
        }
        return normalizedPkgNameBuilder.toString();
    }

    public String dotToSlash(String pathEntry) {
        pathEntry = pathEntry.replace(".", "/");
        pathEntry = this.normalizePackageName(pathEntry);
        return pathEntry;
    }

    public void setRepoName(String repoName, final String outputDir) {
        URI uri = URI.create("git://" + repoName);
        this.fs = this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(){
            {
                this.put("out-dir", outputDir);
                this.put("init", true);
            }
        });
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }
}

