/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport;

import java.io.File;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.xml.format.CategoriesXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Category;
import org.guvnor.common.services.shared.metadata.CategoriesService;
import org.guvnor.common.services.shared.metadata.model.Categories;
import org.guvnor.common.services.shared.metadata.model.CategoryItem;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@ApplicationScoped
public class CategoryImporter {
    @Inject
    FileManager fileManager;
    @Inject
    CategoriesService categoriesService;
    @Inject
    protected MigrationPathManager migrationPathManager;
    private CategoriesXmlFormat categoriesXmlFormat = new CategoriesXmlFormat();

    public void importAll() {
        System.out.println("  Category import started");
        Document xml = null;
        try {
            File categoriesXmlFile = this.fileManager.getCategoriesExportFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xml = db.parse(categoriesXmlFile);
            NodeList children = xml.getChildNodes();
            if (children.getLength() > 1) {
                throw new IllegalArgumentException("Wrong categories.xml format");
            }
            org.drools.workbench.jcr2vfsmigration.xml.model.Categories xmlCategories = this.categoriesXmlFormat.parse(children.item(0));
            Categories vfsCategories = new Categories();
            this.importCategories(xmlCategories.getCategories(), (CategoryItem)vfsCategories);
            this.categoriesService.save(this.migrationPathManager.generatePathForModule("categories.xml"), (Object)vfsCategories, null, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("  Category import ended");
    }

    private void importCategories(Collection<Category> xmlCategoryCollection, CategoryItem vfsCategoryItem) {
        for (Category xmlCategory : xmlCategoryCollection) {
            CategoryItem categoryItem = vfsCategoryItem.addChildren(xmlCategory.getName(), "");
            org.drools.workbench.jcr2vfsmigration.xml.model.Categories xmlSubCategories = xmlCategory.getCategories();
            if (xmlSubCategories == null) continue;
            this.importCategories(xmlSubCategories.getCategories(), categoryItem);
        }
    }
}

