/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport.asset;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.AssetImporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationMemberDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.screens.datamodeller.model.PropertyTypeTO;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.AnnotationMemberDefinition;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.PositionAnnotationDefinition;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.StandardCopyOption;

public class FactModelImporter
implements AssetImporter<DataModelAsset> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MigrationPathManager migrationPathManager;
    @Inject
    private ProjectService<KieProject> projectService;
    @Inject
    private DataModelerService modelerService;
    private Map<String, String> orderedBaseTypes = new TreeMap<String, String>();
    private Map<String, AnnotationDefinitionTO> annotationDefinitions;

    @Override
    public Path importAsset(Module xmlModule, DataModelAsset xmlAsset, Path previousVersionPath) {
        String normalizedPackageName = xmlModule.getNormalizedPackageName();
        Path path = this.migrationPathManager.generatePathForAsset(xmlModule, (XmlAsset)xmlAsset, xmlAsset.getAssetType().toString());
        if (previousVersionPath != null && !previousVersionPath.equals(path)) {
            this.ioService.move(Paths.convert((Path)previousVersionPath), Paths.convert((Path)path), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        this.initBasePropertyTypes();
        this.initAnnotationDefinitions();
        AnnotationDefinitionTO positionAnnotationDef = this.getPositionAnnotationDefinition();
        if (project == null) {
            Path projectRootPath = this.migrationPathManager.generatePathForModule(normalizedPackageName);
            project = new KieProject(projectRootPath, projectRootPath, projectRootPath, projectRootPath, projectRootPath, "");
        }
        DataModelTO dataModelTO = new DataModelTO();
        Iterator objIt = xmlAsset.modelObjects();
        while (objIt.hasNext()) {
            DataModelAsset.DataModelObject obj = (DataModelAsset.DataModelObject)objIt.next();
            DataObjectTO dataObject = new DataObjectTO(obj.getName(), normalizedPackageName, obj.getSuperType());
            int position = 0;
            Iterator propIt = obj.properties();
            while (propIt.hasNext()) {
                DataModelAsset.DataObjectProperty objProp = (DataModelAsset.DataObjectProperty)propIt.next();
                String fieldName = objProp.getName();
                String fieldType = objProp.getType();
                boolean isMultiple = false;
                boolean isBaseType = this.isBaseType(fieldType);
                ObjectPropertyTO property = new ObjectPropertyTO(fieldName, fieldType, isMultiple, isBaseType);
                property.addAnnotation(positionAnnotationDef, "value", (Object)(position + ""));
                ++position;
                dataObject.getProperties().add(property);
            }
            Iterator annIt = obj.annotations();
            while (annIt.hasNext()) {
                DataModelAsset.DataObjectAnnotation objAnn = (DataModelAsset.DataObjectAnnotation)annIt.next();
                String name = objAnn.getName();
                String key = objAnn.getKey();
                String value = objAnn.getValue();
                if ("Role".equals(name)) {
                    dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Role"), key, (Object)value);
                    continue;
                }
                if ("Position".equals(name)) {
                    dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Position"), key, (Object)value);
                    continue;
                }
                if (!"Equals".equals(name)) continue;
                dataObject.addAnnotation(this.annotationDefinitions.get("org.kie.api.definition.type.Key"), key, (Object)value);
            }
            dataModelTO.getDataObjects().add(dataObject);
        }
        this.modelerService.saveModel(dataModelTO, project);
        return path;
    }

    private void initBasePropertyTypes() {
        List baseTypes = this.modelerService.getBasePropertyTypes();
        if (baseTypes != null) {
            for (PropertyTypeTO type : baseTypes) {
                this.orderedBaseTypes.put(type.getName(), type.getClassName());
            }
        }
    }

    private void initAnnotationDefinitions() {
        this.annotationDefinitions = this.modelerService.getAnnotationDefinitions();
    }

    private AnnotationDefinitionTO getPositionAnnotationDefinition() {
        PositionAnnotationDefinition positionAnnotationDef = PositionAnnotationDefinition.getInstance();
        AnnotationDefinitionTO positionAnnotationDefTO = new AnnotationDefinitionTO(positionAnnotationDef.getName(), positionAnnotationDef.getClassName(), positionAnnotationDef.getShortDescription(), positionAnnotationDef.getDescription(), positionAnnotationDef.isObjectAnnotation(), positionAnnotationDef.isPropertyAnnotation());
        for (AnnotationMemberDefinition memberDefinition : positionAnnotationDef.getAnnotationMembers()) {
            AnnotationMemberDefinitionTO memberDefinitionTO = new AnnotationMemberDefinitionTO(memberDefinition.getName(), memberDefinition.getClassName(), memberDefinition.isPrimitiveType(), memberDefinition.isEnum(), memberDefinition.defaultValue(), memberDefinition.getShortDescription(), memberDefinition.getDescription());
            positionAnnotationDefTO.addMember(memberDefinitionTO);
        }
        return positionAnnotationDefTO;
    }

    private Boolean isBaseType(String type) {
        return this.orderedBaseTypes.containsValue(type);
    }
}

