/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.server;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.persistence.SocialClusterMessaging;
import org.kie.uberfire.social.activities.persistence.SocialTimelineCacheClusterPersistence;
import org.kie.uberfire.social.activities.persistence.SocialTimelineCacheInstancePersistence;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialTimelinePersistenceAPI;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
public class SocialTimelinePersistenceProducer {
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    private SocialTimelinePersistenceAPI socialTimelinePersistenceAPI;
    private Gson gson;
    private Type gsonCollectionType;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    SocialEventTypeRepositoryAPI socialEventTypeRepository;
    @Inject
    private SocialClusterMessaging socialClusterMessaging;
    @Inject
    private SocialUserServicesExtendedBackEndImpl userServicesBackend;
    @Inject
    private SocialUserPersistenceAPI socialUserPersistenceAPI;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
        this.socialTimelinePersistenceAPI = this.clusterServiceFactory == null ? new SocialTimelineCacheInstancePersistence(this.gson, this.gsonCollectionType, this.ioService, this.socialEventTypeRepository, this.socialUserPersistenceAPI, this.userServicesBackend, this.fileSystem) : new SocialTimelineCacheClusterPersistence(this.gson, this.gsonCollectionType, this.ioService, this.socialEventTypeRepository, this.socialUserPersistenceAPI, this.socialClusterMessaging, this.userServicesBackend, this.fileSystem);
        this.socialTimelinePersistenceAPI.setup();
    }

    @Produces
    @Named(value="socialTimelinePersistence")
    public SocialTimelinePersistenceAPI socialTimelinePersistenceAPI() {
        return this.socialTimelinePersistenceAPI;
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
        this.gsonCollectionType = new TypeToken<Collection<SocialActivitiesEvent>>(){}.getType();
    }
}

