/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.Entity;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@ApplicationScoped
public class DataModelerEventObserver {
    private static final Logger logger = LoggerFactory.getLogger(DataModelerEventObserver.class);
    private PersistenceDescriptorService descriptorService;
    private IOService ioService;

    public DataModelerEventObserver() {
    }

    @Inject
    public DataModelerEventObserver(PersistenceDescriptorService descriptorService, @Named(value="ioStrategy") IOService ioService) {
        this.descriptorService = descriptorService;
        this.ioService = ioService;
    }

    private void onDataObjectCreated(@Observes DataObjectCreatedEvent event) {
        Path descriptorPath;
        PersistenceDescriptorModel persistenceDescriptor;
        if (this.isPersistable(event.getCurrentDataObject()) && this.isPersistenceAutoUpdateEnabled(event.getCurrentProject()) && (persistenceDescriptor = this.safeLoad(descriptorPath = this.descriptorService.calculatePersistenceDescriptorPath(event.getCurrentProject()))) != null && !persistenceDescriptor.getPersistenceUnit().getClasses().contains(event.getCurrentDataObject().getClassName())) {
            persistenceDescriptor.getPersistenceUnit().getClasses().add(event.getCurrentDataObject().getClassName());
            this.descriptorService.save(descriptorPath, (Object)persistenceDescriptor, null, "Entity added to persistence descriptor");
        }
    }

    private void onDataObjectDeleted(@Observes DataObjectDeletedEvent event) {
        Path descriptorPath;
        PersistenceDescriptorModel persistenceDescriptor;
        if (this.isPersistenceAutoUpdateEnabled(event.getCurrentProject()) && (persistenceDescriptor = this.safeLoad(descriptorPath = this.descriptorService.calculatePersistenceDescriptorPath(event.getCurrentProject()))) != null && persistenceDescriptor.getPersistenceUnit().getClasses().remove(event.getCurrentDataObject().getClassName())) {
            this.descriptorService.save(descriptorPath, (Object)persistenceDescriptor, null, "Entity removed from persistence descriptor");
        }
    }

    private void onDataObjectChanged() {
    }

    private PersistenceDescriptorModel safeLoad(Path path) {
        try {
            if (path != null && this.ioService.exists(Paths.convert((Path)path))) {
                return (PersistenceDescriptorModel)this.descriptorService.load(path);
            }
        }
        catch (Exception e) {
            logger.warn("It was not possible to read persistence descriptor por project: " + path);
        }
        return null;
    }

    private boolean isPersistable(DataObject dataObject) {
        return dataObject != null && dataObject.getAnnotation(Entity.class.getName()) != null;
    }

    private boolean isPersistenceAutoUpdateEnabled(Project project) {
        return true;
    }
}

