/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.events.SystemMessage;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.forge.roaster.model.SyntaxError;
import org.kie.api.builder.KieModule;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.LRUProjectDependenciesClassLoaderCache;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.datamodeller.util.MapClassLoader;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class DataModelerServiceHelper {
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private User identity;
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    @Named(value="LRUProjectDependenciesClassLoaderCache")
    private LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache;
    @Inject
    private LRUBuilderCache builderCache;

    public List<DataModelerError> toDataModelerError(List<DriverError> errors) {
        ArrayList<DataModelerError> result = new ArrayList<DataModelerError>();
        if (errors == null) {
            return result;
        }
        for (DriverError error : errors) {
            DataModelerError dataModelerError = new DataModelerError(error.getId(), error.getMessage(), SystemMessage.Level.ERROR, error.getFile(), error.getLine(), error.getColumn());
            result.add(dataModelerError);
        }
        return result;
    }

    public List<DataModelerError> toDataModelerError(List<SyntaxError> syntaxErrors, Path file) {
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        for (SyntaxError syntaxError : syntaxErrors) {
            DataModelerError error = new DataModelerError(syntaxError.getDescription(), syntaxError.isError() ? SystemMessage.Level.ERROR : SystemMessage.Level.WARNING, Paths.convert((Path)file));
            error.setColumn(syntaxError.getColumn());
            error.setLine(syntaxError.getLine());
            errors.add(error);
        }
        return errors;
    }

    public Map<String, org.uberfire.backend.vfs.Path> toVFSPaths(Map<String, Path> nioPaths) {
        HashMap<String, org.uberfire.backend.vfs.Path> vfsPaths = new HashMap<String, org.uberfire.backend.vfs.Path>();
        if (nioPaths != null) {
            for (String key : nioPaths.keySet()) {
                vfsPaths.put(key, Paths.convert((Path)nioPaths.get(key)));
            }
        }
        return vfsPaths;
    }

    public List<ValidationMessage> toValidationMessage(List<DataModelerError> errors) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (errors == null) {
            return validationMessages;
        }
        for (DataModelerError error : errors) {
            ValidationMessage validationMessage = new ValidationMessage();
            validationMessage.setPath(error.getFile());
            validationMessage.setText(error.getMessage());
            validationMessage.setColumn(error.getColumn());
            validationMessage.setLine(error.getLine());
            validationMessage.setId(error.getId());
            if (error.getLevel() != null) {
                switch (error.getLevel()) {
                    case ERROR: {
                        validationMessage.setLevel(ValidationMessage.Level.ERROR);
                        break;
                    }
                    case WARNING: {
                        validationMessage.setLevel(ValidationMessage.Level.WARNING);
                        break;
                    }
                    case INFO: {
                        validationMessage.setLevel(ValidationMessage.Level.INFO);
                        break;
                    }
                    default: {
                        validationMessage.setLevel(ValidationMessage.Level.ERROR);
                    }
                }
            }
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getIdentifier();
        Date when = new Date();
        CommentedOption option = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return option;
    }

    public Package ensurePackageStructure(Project project, String packageName) {
        Package defaultPackage;
        if (packageName == null || "".equals(packageName) || project == null) {
            return null;
        }
        Package subPackage = defaultPackage = this.projectService.resolveDefaultPackage(project);
        Path subDirPath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath());
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (tokenizer.hasMoreTokens()) {
            String subDirName = tokenizer.nextToken();
            if (!this.ioService.exists(subDirPath = subDirPath.resolve(subDirName))) {
                subPackage = this.projectService.newPackage(subPackage, subDirName);
                continue;
            }
            subPackage = this.projectService.resolvePackage(Paths.convert((Path)subDirPath));
        }
        return subPackage;
    }

    public String getCanonicalFileName(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        String fileName = path.getFileName();
        return fileName.substring(0, fileName.indexOf("."));
    }

    public ClassLoader getProjectClassLoader(KieProject project) {
        ClassLoader projectClassLoader;
        KieModule module = this.builderCache.assertBuilder((Project)project).getKieModuleIgnoringErrors();
        ClassLoader dependenciesClassLoader = this.dependenciesClassLoaderCache.assertDependenciesClassLoader(project);
        if (module instanceof InternalKieModule) {
            InternalKieModule internalModule = (InternalKieModule)module;
            projectClassLoader = new MapClassLoader(internalModule.getClassesMap(true), dependenciesClassLoader);
        } else {
            projectClassLoader = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)module).getClassLoader();
        }
        return projectClassLoader;
    }
}

