/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.base.ClassTypeResolver;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelerServiceHelper;
import org.kie.workbench.common.screens.datamodeller.model.index.FieldName;
import org.kie.workbench.common.screens.datamodeller.model.index.FieldType;
import org.kie.workbench.common.screens.datamodeller.model.index.JavaType;
import org.kie.workbench.common.screens.datamodeller.model.index.JavaTypeInterface;
import org.kie.workbench.common.screens.datamodeller.model.index.JavaTypeName;
import org.kie.workbench.common.screens.datamodeller.model.index.JavaTypeParent;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.JavaTypeIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueFieldNameIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueFieldTypeIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueJavaTypeIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueJavaTypeInterfaceIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueJavaTypeNameIndexTerm;
import org.kie.workbench.common.screens.datamodeller.model.index.terms.valueterms.ValueJavaTypeParentIndexTerm;
import org.kie.workbench.common.screens.javaeditor.type.JavaResourceTypeDefinition;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class JavaFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(JavaFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected JavaResourceTypeDefinition javaResourceTypeDefinition;
    @Inject
    DataModelerServiceHelper dataModelerServiceHelper;

    public boolean supportsPath(Path path) {
        return this.javaResourceTypeDefinition.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            String javaSource = this.ioService.readAllString(path);
            KieProject project = this.getProject(path);
            if (project == null) {
                logger.error("Unable to index: " + path.toUri().toString() + ", project could not be calculated.");
                return null;
            }
            Package pkg = this.getPackage(path);
            if (pkg == null) {
                logger.error("Unable to index: " + path.toUri().toString() + ", package could not be calculated.");
                return null;
            }
            JavaTypeIndexTerm.JAVA_TYPE javaTypeKind = null;
            DefaultIndexBuilder builder = new DefaultIndexBuilder((Project)project, pkg);
            org.jboss.forge.roaster.model.JavaType javaType = Roaster.parse((String)javaSource);
            if (javaType.getSyntaxErrors() == null || javaType.getSyntaxErrors().isEmpty()) {
                String javaTypeName = javaType.getQualifiedName();
                if (javaType.isAnnotation()) {
                    javaTypeKind = JavaTypeIndexTerm.JAVA_TYPE.ANNOTATION;
                } else if (javaType.isInterface()) {
                    javaTypeKind = JavaTypeIndexTerm.JAVA_TYPE.INTERFACE;
                } else if (javaType.isEnum()) {
                    javaTypeKind = JavaTypeIndexTerm.JAVA_TYPE.ENUM;
                } else {
                    javaTypeKind = JavaTypeIndexTerm.JAVA_TYPE.CLASS;
                    this.addJavaTypeTerms((JavaClassSource)javaType, builder, this.getProjectClassLoader(project));
                }
                builder.addGenerator((IndexElementsGenerator)new JavaType(new ValueJavaTypeIndexTerm(javaTypeKind)));
                builder.addGenerator((IndexElementsGenerator)new JavaTypeName(new ValueJavaTypeNameIndexTerm(javaTypeName)));
                index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
            }
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        return index;
    }

    private void addJavaTypeTerms(JavaClassSource javaClassSource, DefaultIndexBuilder builder, ClassLoader classLoader) {
        List fields;
        List implementedInterfaces;
        ClassTypeResolver classTypeResolver = DriverUtils.createClassTypeResolver((JavaClassSource)javaClassSource, (ClassLoader)classLoader);
        String superClass = null;
        HashSet<String> referencedTypes = new HashSet<String>();
        if (javaClassSource.getSuperType() != null) {
            try {
                superClass = classTypeResolver.getFullTypeName(javaClassSource.getSuperType());
                referencedTypes.add(superClass);
                builder.addGenerator((IndexElementsGenerator)new JavaTypeParent(new ValueJavaTypeParentIndexTerm(superClass)));
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to index super class name for class: " + javaClassSource.getQualifiedName() + ", superClass: " + superClass, (Throwable)e);
            }
        }
        if ((implementedInterfaces = javaClassSource.getInterfaces()) != null) {
            for (String implementedInterface : implementedInterfaces) {
                try {
                    implementedInterface = classTypeResolver.getFullTypeName(implementedInterface);
                    referencedTypes.add(implementedInterface);
                    builder.addGenerator((IndexElementsGenerator)new JavaTypeInterface(new ValueJavaTypeInterfaceIndexTerm(implementedInterface)));
                }
                catch (ClassNotFoundException e) {
                    logger.error("Unable to index implemented interface qualified name for class: " + javaClassSource.getQualifiedName() + ", interface: " + implementedInterface, (Throwable)e);
                }
            }
        }
        if ((fields = javaClassSource.getFields()) != null) {
            for (FieldSource field : fields) {
                String fieldName = field.getName();
                Type fieldType = field.getType();
                try {
                    String fieldClassName;
                    if (!DriverUtils.isManagedType((Type)fieldType, (ClassTypeResolver)classTypeResolver)) continue;
                    if (fieldType.isPrimitive()) {
                        fieldClassName = fieldType.getName();
                    } else if (DriverUtils.isSimpleClass((Type)fieldType)) {
                        fieldClassName = classTypeResolver.getFullTypeName(fieldType.getName());
                    } else {
                        Type elementsType = (Type)fieldType.getTypeArguments().get(0);
                        fieldClassName = classTypeResolver.getFullTypeName(elementsType.getName());
                    }
                    referencedTypes.add(fieldClassName);
                    builder.addGenerator((IndexElementsGenerator)new FieldName(new ValueFieldNameIndexTerm(fieldName)));
                    builder.addGenerator((IndexElementsGenerator)new FieldType(new ValueFieldNameIndexTerm(fieldName), new ValueFieldTypeIndexTerm(fieldClassName)));
                }
                catch (Exception e) {
                    logger.error("Unable to index java class field for class: " + javaClassSource.getQualifiedName() + ", fieldName: " + fieldName + " fieldType: " + fieldType);
                }
            }
        }
        for (String referencedType : referencedTypes) {
            builder.addGenerator((IndexElementsGenerator)new org.kie.workbench.common.services.refactoring.model.index.Type(new ValueTypeIndexTerm(referencedType)));
        }
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected KieProject getProject(Path path) {
        return (KieProject)this.projectService.resolveProject(Paths.convert((Path)path));
    }

    protected Package getPackage(Path path) {
        return this.projectService.resolvePackage(Paths.convert((Path)path));
    }

    protected ClassLoader getProjectClassLoader(KieProject project) {
        return this.dataModelerServiceHelper.getProjectClassLoader(project);
    }
}

