/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleIncrementalPayload;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class IncrementalDataModelServiceImpl
implements IncrementalDataModelService {
    private LRUDataModelOracleCache cachePackages;
    private KieProjectService projectService;

    @Inject
    public IncrementalDataModelServiceImpl(@Named(value="PackageDataModelOracleCache") LRUDataModelOracleCache cachePackages, KieProjectService projectService) {
        this.cachePackages = (LRUDataModelOracleCache)((Object)PortablePreconditions.checkNotNull((String)"cachePackages", (Object)((Object)cachePackages)));
        this.projectService = (KieProjectService)PortablePreconditions.checkNotNull((String)"projectService", (Object)projectService);
    }

    public IncrementalDataModelServiceImpl() {
    }

    public PackageDataModelOracleIncrementalPayload getUpdates(Path resourcePath, Imports imports, String factType) {
        PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
        PortablePreconditions.checkNotNull((String)"imports", (Object)imports);
        PortablePreconditions.checkNotNull((String)"factType", (Object)factType);
        PackageDataModelOracleIncrementalPayload dataModel = new PackageDataModelOracleIncrementalPayload();
        try {
            KieProject project = this.resolveProject(resourcePath);
            if (project == null) {
                return dataModel;
            }
            Package pkg = this.resolvePackage(resourcePath);
            if (pkg == null) {
                return dataModel;
            }
            String fullyQualifiedClassName = factType;
            PackageDataModelOracle oracle = this.cachePackages.assertPackageDataModelOracle(project, pkg);
            if (oracle.getProjectModelFields().get(fullyQualifiedClassName) == null) {
                for (Import imp : imports.getImports()) {
                    if (!imp.getType().endsWith(factType)) continue;
                    fullyQualifiedClassName = imp.getType();
                    break;
                }
            }
            if (oracle.getProjectModelFields().get(fullyQualifiedClassName) == null) {
                fullyQualifiedClassName = pkg.getPackageName() + "." + factType;
            }
            if (oracle.getProjectModelFields().get(fullyQualifiedClassName) == null) {
                return dataModel;
            }
            DataModelOracleUtilities.populateDataModel(oracle, dataModel, fullyQualifiedClassName);
            return dataModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private KieProject resolveProject(Path resourcePath) {
        return (KieProject)this.projectService.resolveProject(resourcePath);
    }

    private Package resolvePackage(Path resourcePath) {
        return this.projectService.resolvePackage(resourcePath);
    }
}

