/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.PackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.ProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindRulesByProjectQuery
implements NamedQuery {
    private RuleNameResponseBuilder responseBuilder = new RuleNameResponseBuilder();

    @Override
    public String getName() {
        return "FindRulesByProjectQuery";
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new PackageNameIndexTerm());
                this.add(new ProjectRootPathIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.size() != 2) {
            throw new IllegalArgumentException("Required terms have not been provided. Require 'packageName' and 'projectRoot'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm packageNameValueTerm = normalizedTerms.get("packageName");
        ValueIndexTerm projectPathValueTerm = normalizedTerms.get("projectRoot");
        if (packageNameValueTerm == null || projectPathValueTerm == null) {
            throw new IllegalArgumentException("Required terms have not been provided. Require 'packageName' and 'projectRoot'.");
        }
        BooleanQuery query = new BooleanQuery();
        if (!useWildcards) {
            query.add((Query)new TermQuery(new Term(packageNameValueTerm.getTerm(), packageNameValueTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term(projectPathValueTerm.getTerm(), projectPathValueTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST);
        } else {
            query.add((Query)new WildcardQuery(new Term(packageNameValueTerm.getTerm(), packageNameValueTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST);
            query.add((Query)new WildcardQuery(new Term(projectPathValueTerm.getTerm(), projectPathValueTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST);
        }
        query.add((Query)new WildcardQuery(new Term("ruleName", "*")), BooleanClause.Occur.MUST);
        return query;
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    private static class RuleNameResponseBuilder
    implements ResponseBuilder {
        private RuleNameResponseBuilder() {
        }

        @Override
        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        @Override
        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            HashSet<String> uniqueRuleNames = new HashSet<String>();
            for (KObject kObject : kObjects) {
                Set<String> ruleNames = this.getRuleNamesFromKObject(kObject);
                uniqueRuleNames.addAll(ruleNames);
            }
            for (String ruleName : uniqueRuleNames) {
                RefactoringStringPageRow row = new RefactoringStringPageRow();
                row.setValue((Object)ruleName);
                result.add((RefactoringPageRow)row);
            }
            return result;
        }

        private Set<String> getRuleNamesFromKObject(KObject kObject) {
            HashSet<String> ruleNames = new HashSet<String>();
            if (kObject == null) {
                return ruleNames;
            }
            for (KProperty property : kObject.getProperties()) {
                if (!property.getName().equals("ruleName")) continue;
                ruleNames.add(property.getValue().toString());
            }
            return ruleNames;
        }
    }
}

