/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.DefaultResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.RuleIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@ApplicationScoped
public class FindRulesQuery
implements NamedQuery {
    @Inject
    private DefaultResponseBuilder responseBuilder;

    @Override
    public String getName() {
        return "FindRulesQuery";
    }

    @Override
    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new RuleIndexTerm());
            }
        };
    }

    @Override
    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        PortablePreconditions.checkNotNull((String)"terms", terms);
        if (terms.size() != 1) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'ruleName'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm ruleTerm = normalizedTerms.get("ruleName");
        if (ruleTerm == null) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'ruleName'.");
        }
        QueryBuilder builder = new QueryBuilder();
        if (useWildcards) {
            builder.useWildcards();
        }
        builder.addTerm(ruleTerm);
        return builder.build();
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }

    @Override
    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }
}

