/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;

public class ObjectPropertyImpl
extends AbstractHasAnnotations
implements ObjectProperty {
    private String name;
    private String className;
    private String bag;
    private boolean multiple;
    private int modifiers = 0;
    private int fileOrder = -1;
    private Visibility visibility = Visibility.PUBLIC;
    private boolean _static = false;
    private boolean _final = false;
    public static final String DEFAULT_PROPERTY_BAG = "java.util.List";

    public ObjectPropertyImpl() {
    }

    public ObjectPropertyImpl(String name, String className, boolean multiple) {
        this(name, className, multiple, Visibility.PUBLIC, false, false);
    }

    public ObjectPropertyImpl(String name, String className, boolean multiple, Visibility visibility, boolean isStatic, boolean isFinal) {
        this(name, className, multiple, DEFAULT_PROPERTY_BAG, visibility, isStatic, isFinal);
    }

    public ObjectPropertyImpl(String name, String className, boolean multiple, String bag) {
        this(name, className, multiple, bag, Visibility.PUBLIC, false, false);
    }

    public ObjectPropertyImpl(String name, String className, boolean multiple, String bag, Visibility visibility, boolean isStatic, boolean isFinal) {
        this.name = name;
        this.className = className;
        this.bag = bag;
        this.multiple = multiple;
        this.visibility = visibility;
        this._static = isStatic;
        this._final = isFinal;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getBag() {
        return this.bag;
    }

    @Override
    public void setBag(String bag) {
        this.bag = bag;
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        if (!multiple) {
            this.setBag(null);
        }
    }

    @Override
    public boolean isArray() {
        return this.getClassName() != null && this.className.endsWith("[]");
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public boolean isBaseType() {
        return PropertyTypeFactoryImpl.getInstance().isBasePropertyType(this.getClassName());
    }

    @Override
    public boolean isPrimitiveType() {
        return NamingUtils.isPrimitiveTypeClass(this.getClassName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isStatic() {
        return this._static;
    }

    @Override
    public boolean isFinal() {
        return this._final;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public int getFileOrder() {
        return this.fileOrder;
    }

    public void setFileOrder(int fileOrder) {
        this.fileOrder = fileOrder;
    }

    @Override
    public boolean isPackagePrivate() {
        return Visibility.PACKAGE_PRIVATE == this.visibility;
    }

    @Override
    public boolean isPublic() {
        return Visibility.PUBLIC == this.visibility;
    }

    @Override
    public boolean isPrivate() {
        return Visibility.PRIVATE == this.visibility;
    }

    @Override
    public boolean isProtected() {
        return Visibility.PROTECTED == this.visibility;
    }

    @Override
    public Visibility getVisibilty() {
        return this.visibility;
    }

    @Override
    public void setBaseType(boolean baseType) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectPropertyImpl that = (ObjectPropertyImpl)o;
        if (this.multiple != that.multiple) {
            return false;
        }
        if (this.modifiers != that.modifiers) {
            return false;
        }
        if (this.fileOrder != that.fileOrder) {
            return false;
        }
        if (this._static != that._static) {
            return false;
        }
        if (this._final != that._final) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.bag != null ? !this.bag.equals(that.bag) : that.bag != null) {
            return false;
        }
        return this.visibility == that.visibility;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.bag != null ? this.bag.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.multiple ? 1 : 0);
        result = ~(~result);
        result = 31 * result + this.modifiers;
        result = ~(~result);
        result = 31 * result + this.fileOrder;
        result = ~(~result);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this._static ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this._final ? 1 : 0);
        result = ~(~result);
        return result;
    }
}

