/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import org.kie.workbench.common.services.datamodeller.util.PortableStringUtils;

public class NamingUtils {
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String CHAR = "char";
    public static final String BOOLEAN = "boolean";

    public static String extractClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(index + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String extractPackageName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(0, index);
        }
        return null;
    }

    public static boolean isPrimitiveTypeClass(String className) {
        return Byte.class.getName().equals(className) || Short.class.getName().equals(className) || Integer.class.getName().equals(className) || Long.class.getName().equals(className) || Float.class.getName().equals(className) || Double.class.getName().equals(className) || Character.class.getName().equals(className) || Boolean.class.getName().equals(className);
    }

    public static boolean isPrimitiveTypeId(String type) {
        return BYTE.equals(type) || SHORT.equals(type) || INT.equals(type) || LONG.equals(type) || FLOAT.equals(type) || DOUBLE.equals(type) || CHAR.equals(type) || BOOLEAN.equals(type);
    }

    public static boolean isByteId(String type) {
        return BYTE.equals(type != null ? type.trim() : type);
    }

    public static boolean isCharId(String type) {
        return CHAR.equals(type != null ? type.trim() : type);
    }

    public static boolean isLongId(String type) {
        return LONG.equals(type != null ? type.trim() : type);
    }

    public static boolean isFloatId(String type) {
        return FLOAT.equals(type != null ? type.trim() : type);
    }

    public static boolean isDoubleId(String type) {
        return FLOAT.equals(type != null ? type.trim() : type);
    }

    public static String getClassForPrimitiveTypeId(String type) {
        if (BYTE.equals(type)) {
            return Byte.class.getName();
        }
        if (SHORT.equals(type)) {
            return Short.class.getName();
        }
        if (INT.equals(type)) {
            return Integer.class.getName();
        }
        if (LONG.equals(type)) {
            return Long.class.getName();
        }
        if (FLOAT.equals(type)) {
            return Float.class.getName();
        }
        if (DOUBLE.equals(type)) {
            return Double.class.getName();
        }
        if (CHAR.equals(type)) {
            return Character.class.getName();
        }
        if (BOOLEAN.equals(type)) {
            return Boolean.class.getName();
        }
        return null;
    }

    public static boolean isQualifiedName(String type) {
        String[] tokens = NamingUtils.tokenizeClassName(type);
        return tokens != null && tokens.length > 1;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static String createQualifiedName(String packageName, String className) {
        if (packageName != null && !"".equals(packageName)) {
            return packageName + "." + className;
        }
        return className;
    }

    public static Object parsePrimitiveValue(String type, String value) throws NumberFormatException {
        if (value == null) {
            return null;
        }
        if (BYTE.equals(type)) {
            return Byte.valueOf(value);
        }
        if (SHORT.equals(type)) {
            return Short.valueOf(value);
        }
        if (INT.equals(type)) {
            return Integer.valueOf(value);
        }
        if (LONG.equals(type)) {
            return NamingUtils.parseLongValue(value);
        }
        if (FLOAT.equals(type)) {
            return NamingUtils.parseFloatValue(value);
        }
        if (DOUBLE.equals(type)) {
            return NamingUtils.parseDoubleValue(value);
        }
        if (CHAR.equals(type)) {
            return value.trim().length() > 0 ? Character.valueOf(value.trim().charAt(0)) : null;
        }
        if (BOOLEAN.equals(type)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static Long parseLongValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'L');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Long.valueOf(trimmedValue);
    }

    public static Float parseFloatValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'f');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Float.valueOf(trimmedValue);
    }

    public static Double parseDoubleValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'd');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Double.valueOf(trimmedValue);
    }

    public static String normalizeClassName(String className) {
        if (className != null && className.contains("$")) {
            return className.replace("$", ".");
        }
        return className;
    }
}

