/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.servlet.ServletDefinition;
import java.io.IOException;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public abstract class AbstractServletPipeline {
    public static final String REQUEST_DISPATCHER_REQUEST = "javax.servlet.forward.servlet_path";

    protected abstract boolean hasServletsMapped();

    protected abstract ServletDefinition[] servletDefinitions();

    public void init(ServletContext servletContext, Injector injector) throws ServletException {
        Set initializedSoFar = Sets.newIdentityHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions()) {
            servletDefinition.init(servletContext, injector, initializedSoFar);
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        for (ServletDefinition servletDefinition : this.servletDefinitions()) {
            if (!servletDefinition.service(request, response)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        Set destroyedSoFar = Sets.newIdentityHashSet();
        for (ServletDefinition servletDefinition : this.servletDefinitions()) {
            servletDefinition.destroy(destroyedSoFar);
        }
    }

    RequestDispatcher getRequestDispatcher(String path) {
        final String newRequestUri = path;
        for (final ServletDefinition servletDefinition : this.servletDefinitions()) {
            if (!servletDefinition.shouldServe(path)) continue;
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    Preconditions.checkState((!servletResponse.isCommitted() ? 1 : 0) != 0, (Object)"Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                    servletResponse.resetBuffer();
                    Object requestToProcess = servletRequest instanceof HttpServletRequest ? new RequestDispatcherRequestWrapper(servletRequest, newRequestUri) : servletRequest;
                    this.doServiceImpl(servletDefinition, (ServletRequest)requestToProcess, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    this.doServiceImpl(servletDefinition, servletRequest, servletResponse);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doServiceImpl(ServletDefinition servletDefinition2, ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    servletRequest.setAttribute(AbstractServletPipeline.REQUEST_DISPATCHER_REQUEST, (Object)Boolean.TRUE);
                    try {
                        servletDefinition2.doService(servletRequest, servletResponse);
                    }
                    finally {
                        servletRequest.removeAttribute(AbstractServletPipeline.REQUEST_DISPATCHER_REQUEST);
                    }
                }
            };
        }
        return null;
    }

    private static class RequestDispatcherRequestWrapper
    extends HttpServletRequestWrapper {
        private final String newRequestUri;

        public RequestDispatcherRequestWrapper(ServletRequest servletRequest, String newRequestUri) {
            super((HttpServletRequest)servletRequest);
            this.newRequestUri = newRequestUri;
        }

        public String getRequestURI() {
            return this.newRequestUri;
        }
    }
}

