/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import java.util.List;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.participant.CustomCodeCallbackHandler;
import org.apache.log4j.Logger;

public class CustomCodeInvoker
implements LiveInstanceChangeListener,
ConfigChangeListener,
ExternalViewChangeListener {
    private static Logger LOG = Logger.getLogger(CustomCodeInvoker.class);
    private final CustomCodeCallbackHandler _callback;
    private final String _partitionKey;

    public CustomCodeInvoker(CustomCodeCallbackHandler callback, String partitionKey) {
        this._callback = callback;
        this._partitionKey = partitionKey;
    }

    private void callParticipantCode(NotificationContext context) {
        if (context.getType() == NotificationContext.Type.CALLBACK) {
            String resourceName;
            String sessionId;
            String instance;
            PropertyKey.Builder keyBuilder;
            HelixManager manager = context.getManager();
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            CurrentState curState = (CurrentState)accessor.getProperty((keyBuilder = accessor.keyBuilder()).currentState(instance = manager.getInstanceName(), sessionId = manager.getSessionId(), resourceName = this._partitionKey.substring(0, this._partitionKey.lastIndexOf(95))));
            if (curState == null) {
                return;
            }
            String state = curState.getState(this._partitionKey);
            if (state == null || !state.equalsIgnoreCase("LEADER")) {
                return;
            }
        }
        try {
            this._callback.onCallback(context);
        }
        catch (Exception e) {
            LOG.error((Object)("Error invoking callback:" + this._callback), (Throwable)e);
        }
    }

    @Override
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        LOG.info((Object)"onLiveInstanceChange() invoked");
        this.callParticipantCode(changeContext);
    }

    @Override
    public void onConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        LOG.info((Object)"onConfigChange() invoked");
        this.callParticipantCode(changeContext);
    }

    @Override
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
        LOG.info((Object)"onExternalViewChange() invoked");
        this.callParticipantCode(changeContext);
    }
}

