/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskCallbackContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskResult;
import org.apache.helix.task.TaskRunner;
import org.apache.helix.task.TaskUtil;
import org.apache.log4j.Logger;

@StateModelInfo(states={"{'NOT USED BY HELIX'}"}, initialState="INIT")
public class TaskStateModel
extends StateModel {
    private static final Logger LOG = Logger.getLogger(TaskStateModel.class);
    private final HelixManager _manager;
    private final ExecutorService _taskExecutor;
    private final Map<String, TaskFactory> _taskFactoryRegistry;
    private final Timer _timer = new Timer("TaskStateModel time out daemon", true);
    private TaskRunner _taskRunner;

    public TaskStateModel(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry) {
        this._manager = manager;
        this._taskFactoryRegistry = taskFactoryRegistry;
        this._taskExecutor = Executors.newFixedThreadPool(40, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TaskStateModel-thread-pool");
            }
        });
    }

    public boolean isShutdown() {
        return this._taskExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this._taskExecutor.isTerminated();
    }

    public void shutdown() {
        this.reset();
        this._taskExecutor.shutdown();
        this._timer.cancel();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this._taskExecutor.awaitTermination(timeout, unit);
    }

    @Transition(to="RUNNING", from="INIT")
    public void onBecomeRunningFromInit(Message msg, NotificationContext context) {
        this.startTask(msg, msg.getPartitionName());
    }

    @Transition(to="STOPPED", from="RUNNING")
    public String onBecomeStoppedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info((Object)String.format("Task %s completed with result %s.", msg.getPartitionName(), r));
        return r.getInfo();
    }

    @Transition(to="COMPLETED", from="RUNNING")
    public void onBecomeCompletedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.COMPLETED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
    }

    @Transition(to="TIMED_OUT", from="RUNNING")
    public String onBecomeTimedOutFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.CANCELED) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        return r.getInfo();
    }

    @Transition(to="TASK_ERROR", from="RUNNING")
    public String onBecomeTaskErrorFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        TaskResult r = this._taskRunner.waitTillDone();
        if (r.getStatus() != TaskResult.Status.ERROR) {
            throw new IllegalStateException(String.format("Partition %s received a state transition to %s but the result status code is %s.", new Object[]{msg.getPartitionName(), msg.getToState(), r.getStatus()}));
        }
        return r.getInfo();
    }

    @Transition(to="RUNNING", from="STOPPED")
    public void onBecomeRunningFromStopped(Message msg, NotificationContext context) {
        this.startTask(msg, msg.getPartitionName());
    }

    @Transition(to="DROPPED", from="INIT")
    public void onBecomeDroppedFromInit(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="DROPPED", from="RUNNING")
    public void onBecomeDroppedFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info((Object)String.format("Task partition %s returned result %s.", msg.getPartitionName(), r));
        this._taskRunner = null;
    }

    @Transition(to="DROPPED", from="COMPLETED")
    public void onBecomeDroppedFromCompleted(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="DROPPED", from="STOPPED")
    public void onBecomeDroppedFromStopped(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="DROPPED", from="TIMED_OUT")
    public void onBecomeDroppedFromTimedOut(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="DROPPED", from="TASK_ERROR")
    public void onBecomeDroppedFromTaskError(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="RUNNING")
    public void onBecomeInitFromRunning(Message msg, NotificationContext context) {
        String taskPartition = msg.getPartitionName();
        if (this._taskRunner == null) {
            throw new IllegalStateException(String.format("Invalid state transition. There is no running task for partition %s.", taskPartition));
        }
        this._taskRunner.cancel();
        TaskResult r = this._taskRunner.waitTillDone();
        LOG.info((Object)String.format("Task partition %s returned result %s.", msg.getPartitionName(), r));
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="COMPLETED")
    public void onBecomeInitFromCompleted(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="STOPPED")
    public void onBecomeInitFromStopped(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="TIMED_OUT")
    public void onBecomeInitFromTimedOut(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Transition(to="INIT", from="TASK_ERROR")
    public void onBecomeInitFromTaskError(Message msg, NotificationContext context) {
        this._taskRunner = null;
    }

    @Override
    public void reset() {
        if (this._taskRunner != null) {
            this._taskRunner.cancel();
        }
    }

    private void startTask(Message msg, String taskPartition) {
        int pId;
        JobConfig cfg = TaskUtil.getJobCfg(this._manager, msg.getResourceName());
        TaskConfig taskConfig = null;
        String command = cfg.getCommand();
        JobContext ctx = TaskUtil.getJobContext(this._manager, msg.getResourceName());
        if (ctx.getTaskIdForPartition(pId = Integer.parseInt(taskPartition.substring(taskPartition.lastIndexOf(95) + 1))) != null && (taskConfig = cfg.getTaskConfig(ctx.getTaskIdForPartition(pId))) != null && taskConfig.getCommand() != null) {
            command = taskConfig.getCommand();
        }
        String target = ctx.getTargetForPartition(pId);
        if (taskConfig == null && target != null) {
            taskConfig = TaskConfig.from(target);
        }
        TaskCallbackContext callbackContext = new TaskCallbackContext();
        callbackContext.setManager(this._manager);
        callbackContext.setJobConfig(cfg);
        callbackContext.setTaskConfig(taskConfig);
        if (command == null || this._taskFactoryRegistry == null || !this._taskFactoryRegistry.containsKey(command)) {
            throw new IllegalStateException("No callback implemented for task " + command);
        }
        TaskFactory taskFactory = this._taskFactoryRegistry.get(command);
        Task task = taskFactory.createNewTask(callbackContext);
        this._taskRunner = new TaskRunner(task, msg.getResourceName(), taskPartition, msg.getTgtName(), this._manager, msg.getTgtSessionId());
        this._taskExecutor.submit(this._taskRunner);
        this._taskRunner.waitTillStarted();
        this._timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (TaskStateModel.this._taskRunner != null) {
                    TaskStateModel.this._taskRunner.timeout();
                }
            }
        }, cfg.getTimeoutPerTask());
    }
}

