/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.builder;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public class SearchEmptyQueryBuilder
implements QueryBuilder<SearchEmptyQueryBuilder> {
    private final BooleanQuery query = new BooleanQuery();
    private boolean useWildcards = false;

    public SearchEmptyQueryBuilder() {
        this(false);
    }

    public SearchEmptyQueryBuilder(boolean useWildcards) {
        this.useWildcards = useWildcards;
    }

    @Override
    public SearchEmptyQueryBuilder useWildcards() {
        this.useWildcards = true;
        return this;
    }

    @Override
    public Query build() {
        return this.query;
    }

    @Override
    public SearchEmptyQueryBuilder addTerm(ValueIndexTerm term) {
        if (term.getValue().trim().isEmpty()) {
            this.query.add((Query)new WildcardQuery(new Term(term.getTerm(), "*")), BooleanClause.Occur.MUST_NOT);
        } else if (term.getValue().trim().equals("*")) {
            this.query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        } else if (!this.useWildcards) {
            this.query.add((Query)new TermQuery(new Term(term.getTerm(), term.getValue().toLowerCase())), BooleanClause.Occur.MUST);
        } else {
            this.query.add((Query)new WildcardQuery(new Term(term.getTerm(), term.getValue().toLowerCase())), BooleanClause.Occur.MUST);
        }
        return this;
    }

    public SearchEmptyQueryBuilder addRuleNameWildCardTerm() {
        this.query.add((Query)new WildcardQuery(new Term("ruleName", "*")), BooleanClause.Occur.MUST);
        return this;
    }
}

