/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final int HISTORY_PAGE_SIZE = 10;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="system")
    private Repository systemRepository;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private RepositoryFactory repositoryFactory;
    @Inject
    private Event<NewRepositoryEvent> event;
    @Inject
    private Event<RepositoryRemovedEvent> repositoryRemovedEvent;
    @Inject
    private BackwardCompatibleUtil backward;
    private Map<String, Repository> configuredRepositories = new HashMap<String, Repository>();
    private Map<Path, Repository> rootToRepo = new HashMap<Path, Repository>();

    @PostConstruct
    public void loadRepositories() {
        List repoConfigs = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (repoConfigs != null && !repoConfigs.isEmpty()) {
            for (ConfigGroup config : repoConfigs) {
                Collection branches;
                Repository repository = this.repositoryFactory.newRepository(config);
                this.configuredRepositories.put(repository.getAlias(), repository);
                this.rootToRepo.put(repository.getRoot(), repository);
                if (!(repository instanceof GitRepository) || (branches = repository.getBranches()) == null || branches.isEmpty()) continue;
                for (String branch : branches) {
                    this.rootToRepo.put(repository.getBranchRoot(branch), repository);
                }
            }
        }
    }

    public Repository getRepository(String alias) {
        return this.configuredRepositories.get(alias);
    }

    public Repository getRepository(FileSystem fs) {
        if (fs == null) {
            return null;
        }
        for (Repository repository : this.configuredRepositories.values()) {
            if (!Paths.convert((Path)repository.getRoot()).getFileSystem().equals(fs)) continue;
            return repository;
        }
        if (Paths.convert((Path)this.systemRepository.getRoot()).getFileSystem().equals(fs)) {
            return this.systemRepository;
        }
        return null;
    }

    public Repository getRepository(Path root) {
        return this.rootToRepo.get(root);
    }

    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.configuredRepositories.values());
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, Map<String, Object> env) throws RepositoryAlreadyExistsException {
        try {
            Repository repository = this.createRepository(scheme, alias, env);
            if (organizationalUnit != null && repository != null) {
                this.organizationalUnitService.addRepository(organizationalUnit, repository);
            }
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Repository createRepository(String scheme, String alias, Map<String, Object> env) {
        Repository repository;
        if (this.configuredRepositories.containsKey(alias) || SystemRepository.SYSTEM_REPO.getAlias().equals(alias)) {
            throw new RepositoryAlreadyExistsException(alias);
        }
        Repository repo = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            if (!env.containsKey("scheme")) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
            }
            if (env.containsKey("branch")) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("branch", env.get("branch")));
            }
            for (Map.Entry<String, Object> entry : env.entrySet()) {
                if (entry.getKey().startsWith("crypt:")) {
                    repositoryConfig.addConfigItem((ConfigItem)this.configurationFactory.newSecuredConfigItem(entry.getKey(), entry.getValue().toString()));
                    continue;
                }
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem(entry.getKey(), entry.getValue()));
            }
            repository = repo = this.createRepository(repositoryConfig);
        }
        catch (Exception e) {
            try {
                logger.error("Error during create repository", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (repo != null) {
                    this.event.fire((Object)new NewRepositoryEvent(repo));
                }
                throw throwable;
            }
        }
        this.configurationService.endBatch();
        if (repo != null) {
            this.event.fire((Object)new NewRepositoryEvent(repo));
        }
        return repository;
    }

    private Repository createRepository(ConfigGroup repositoryConfig) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.put(repository.getAlias(), repository);
        this.rootToRepo.put(repository.getRoot(), repository);
        return repository;
    }

    public String normalizeRepositoryName(String name) {
        return TextUtil.normalizeRepositoryName((String)name);
    }

    public boolean validateRepositoryName(String name) {
        return name != null && !"".equals(name) && name.equals(this.normalizeRepositoryName(name));
    }

    public void addGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).add(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
        this.configuredRepositories.put(updatedRepo.getAlias(), updatedRepo);
        this.rootToRepo.put(updatedRepo.getRoot(), updatedRepo);
    }

    public void removeGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).remove(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
        this.configuredRepositories.put(updatedRepo.getAlias(), updatedRepo);
        this.rootToRepo.put(updatedRepo.getRoot(), updatedRepo);
    }

    protected ConfigGroup findRepositoryConfig(String alias) {
        List groups = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(alias)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeRepository(String alias) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(alias);
        try {
            Repository repo;
            this.configurationService.startBatch();
            if (thisRepositoryConfig != null) {
                this.configurationService.removeConfiguration(thisRepositoryConfig);
            }
            if ((repo = this.configuredRepositories.remove(alias)) != null) {
                this.rootToRepo.remove(repo.getRoot());
                this.repositoryRemovedEvent.fire((Object)new RepositoryRemovedEvent(repo));
                this.ioService.delete(Paths.convert((Path)repo.getRoot()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
            for (OrganizationalUnit ou : organizationalUnits) {
                for (Repository repository : ou.getRepositories()) {
                    if (!repository.getAlias().equals(alias)) continue;
                    this.organizationalUnitService.removeRepository(ou, repository);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error during remove repository", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    public Repository updateRepository(Repository repository, Map<String, Object> config) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig != null && config != null) {
            try {
                this.configurationService.startBatch();
                for (Map.Entry<String, Object> entry : config.entrySet()) {
                    ConfigItem configItem = thisRepositoryConfig.getConfigItem(entry.getKey());
                    if (configItem == null) {
                        thisRepositoryConfig.addConfigItem(this.configurationFactory.newConfigItem(entry.getKey(), entry.getValue()));
                        continue;
                    }
                    configItem.setValue(entry.getValue());
                }
                this.configurationService.updateConfiguration(thisRepositoryConfig);
                Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
                this.configuredRepositories.put(updatedRepo.getAlias(), updatedRepo);
                this.rootToRepo.put(updatedRepo.getRoot(), updatedRepo);
                Repository repository2 = updatedRepo;
                return repository2;
            }
            catch (Exception e) {
                logger.error("Error during remove repository", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.configurationService.endBatch();
            }
        }
        throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
    }

    public RepositoryInfo getRepositoryInfo(String alias) {
        Repository repo = this.getRepository(alias);
        String ouName = null;
        for (OrganizationalUnit ou : this.organizationalUnitService.getOrganizationalUnits()) {
            for (Repository repository : ou.getRepositories()) {
                if (!repository.getAlias().equals(alias)) continue;
                ouName = ou.getName();
            }
        }
        List<VersionRecord> initialRecordList = this.getRepositoryHistory(alias, 0, 10);
        return new RepositoryInfo(alias, ouName, repo.getRoot(), repo.getPublicURIs(), initialRecordList);
    }

    public List<VersionRecord> getRepositoryHistory(String alias, int startIndex) {
        return this.getRepositoryHistory(alias, startIndex, startIndex + 10);
    }

    public List<VersionRecord> getRepositoryHistoryAll(String alias) {
        return this.getRepositoryHistory(alias, 0, -1);
    }

    public List<VersionRecord> getRepositoryHistory(String alias, int startIndex, int endIndex) {
        Repository repo = this.getRepository(alias);
        if (repo == null) {
            return Collections.EMPTY_LIST;
        }
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert((Path)repo.getRoot()), VersionAttributeView.class);
        List records = versionAttributeView.readAttributes().history().records();
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex < 0 || endIndex > records.size()) {
            endIndex = records.size();
        }
        if (startIndex >= records.size() || startIndex >= endIndex) {
            return Collections.emptyList();
        }
        Collections.reverse(records);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(endIndex - startIndex);
        for (VersionRecord record : records.subList(startIndex, endIndex)) {
            result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
        }
        return result;
    }

    public void updateRegisteredRepositories(@Observes @org.guvnor.structure.backend.config.Repository SystemRepositoryChangedEvent changedEvent) {
        this.flush();
    }

    public void updateBranch(@Observes NewBranchEvent changedEvent) {
        Repository repository;
        if (this.configuredRepositories.containsKey(changedEvent.getRepositoryAlias()) && (repository = this.configuredRepositories.get(changedEvent.getRepositoryAlias())) instanceof GitRepository) {
            ((GitRepository)repository).addBranch(changedEvent.getBranchName(), changedEvent.getBranchPath());
            this.rootToRepo.put(changedEvent.getBranchPath(), repository);
        }
    }

    private void flush() {
        this.configuredRepositories.clear();
        this.loadRepositories();
    }
}

