/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.block;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.BlockTreeTermsReader;
import org.apache.lucene.codecs.BlockTreeTermsWriter;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.block.BlockPostingsReader;
import org.apache.lucene.codecs.block.BlockPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public final class BlockPostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;

    public BlockPostingsFormat() {
        this(25, 48);
    }

    public BlockPostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        super("Block");
        this.minTermBlockSize = minTermBlockSize;
        assert (minTermBlockSize > 1);
        this.maxTermBlockSize = maxTermBlockSize;
        assert (minTermBlockSize <= maxTermBlockSize);
    }

    public String toString() {
        return this.getName() + "(blocksize=" + 128 + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        BlockTreeTermsWriter blockTreeTermsWriter;
        block3: {
            BlockPostingsWriter postingsWriter = new BlockPostingsWriter(state);
            boolean success = false;
            try {
                BlockTreeTermsWriter ret = new BlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                blockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
        }
        return blockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        BlockTreeTermsReader blockTreeTermsReader;
        block3: {
            BlockPostingsReader postingsReader = new BlockPostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, state.segmentSuffix);
            boolean success = false;
            try {
                BlockTreeTermsReader ret = new BlockTreeTermsReader(state.dir, state.fieldInfos, state.segmentInfo, (PostingsReaderBase)postingsReader, state.context, state.segmentSuffix, state.termsIndexDivisor);
                success = true;
                blockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
        }
        return blockTreeTermsReader;
    }
}

