/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.NumericPayloadTokenFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class NumericPayloadTokenFilterFactory
extends TokenFilterFactory {
    private float payload;
    private String typeMatch;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String payloadArg = args.get("payload");
        this.typeMatch = args.get("typeMatch");
        if (payloadArg == null || this.typeMatch == null) {
            throw new IllegalArgumentException("Both payload and typeMatch are required");
        }
        this.payload = Float.parseFloat(payloadArg);
    }

    public NumericPayloadTokenFilter create(TokenStream input) {
        return new NumericPayloadTokenFilter(input, this.payload, this.typeMatch);
    }
}

