/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTagCommand
extends GitCommand<List<Ref>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            try {
                Map<String, Ref> refList = this.repo.getRefDatabase().getRefs("refs/tags/");
                for (Ref ref : refList.values()) {
                    tags.add(ref);
                }
                Object var7_7 = null;
                revWalk.release();
            }
            catch (IOException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            revWalk.release();
            throw throwable;
        }
        Collections.sort(tags, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return tags;
    }
}

