/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractXStreamConverter
implements Converter {
    private final Class type;

    protected AbstractXStreamConverter(Class type) {
        this.type = type;
    }

    public boolean canConvert(Class clazz) {
        return this.type.isAssignableFrom(clazz);
    }

    protected void writeAttribute(HierarchicalStreamWriter writer, String name, String value) {
        if (value != null) {
            writer.addAttribute(name, value);
        }
    }

    protected void writeString(HierarchicalStreamWriter writer, String name, String value) {
        if (value != null) {
            writer.startNode(name);
            writer.setValue(value);
            writer.endNode();
        }
    }

    protected void writeObject(HierarchicalStreamWriter writer, MarshallingContext context, String name, Object value) {
        if (value != null) {
            writer.startNode(name);
            context.convertAnother(value);
            writer.endNode();
        }
    }

    protected void writeList(HierarchicalStreamWriter writer, String listName, String itemName, Iterable<String> list) {
        Iterator<String> i;
        if (list != null && (i = list.iterator()).hasNext()) {
            writer.startNode(listName);
            while (i.hasNext()) {
                writer.startNode(itemName);
                writer.setValue(i.next());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    protected void writeObjectList(HierarchicalStreamWriter writer, MarshallingContext context, String listName, String itemName, Iterable<?> list) {
        Iterator<?> i;
        if (list != null && (i = list.iterator()).hasNext()) {
            writer.startNode(listName);
            while (i.hasNext()) {
                this.writeObject(writer, context, itemName, i.next());
            }
            writer.endNode();
        }
    }

    protected void writePropertyMap(HierarchicalStreamWriter writer, MarshallingContext context, String mapName, Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            writer.startNode(mapName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                writer.startNode("property");
                writer.addAttribute("key", entry.getKey());
                writer.addAttribute("value", entry.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    protected void readNodes(HierarchicalStreamReader reader, NodeReader nodeReader) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            nodeReader.onNode(reader, reader.getNodeName(), reader.getValue());
            reader.moveUp();
        }
    }

    protected List<String> readList(HierarchicalStreamReader reader) {
        ArrayList<String> list = new ArrayList<String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(reader.getValue());
            reader.moveUp();
        }
        return list;
    }

    protected <T> T readObject(HierarchicalStreamReader reader, UnmarshallingContext context, Class<? extends T> clazz) {
        return (T)context.convertAnother((Object)reader.getValue(), clazz);
    }

    protected <T> List<T> readObjectList(HierarchicalStreamReader reader, UnmarshallingContext context, Class<? extends T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(context.convertAnother((Object)reader.getValue(), clazz));
            reader.moveUp();
        }
        return list;
    }

    protected Map<String, String> readPropertyMap(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getAttribute("key"), reader.getAttribute("value"));
            reader.moveUp();
        }
        return map;
    }

    public static interface NodeReader {
        public void onNode(HierarchicalStreamReader var1, String var2, String var3);
    }
}

