/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.workbench.jcr2vfsmigration.xml.format.CategoryXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Categories;
import org.drools.workbench.jcr2vfsmigration.xml.model.Category;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CategoriesXmlFormat
implements XmlFormat<Categories> {
    public static final String CATEGORIES = "categories";
    private CategoryXmlFormat categoryXmlFormat;

    @Override
    public void format(StringBuilder sb, Categories categories) {
        if (sb == null || categories == null) {
            throw new IllegalArgumentException("No output or Categories specified");
        }
        this.initialize();
        sb.append("<").append(CATEGORIES).append(">");
        Iterator<Category> it = categories.getCategories().iterator();
        while (it.hasNext()) {
            this.categoryXmlFormat.format(sb, it.next());
        }
        sb.append("</").append(CATEGORIES).append(">");
    }

    @Override
    public Categories parse(Node categoriesNode) {
        if (categoriesNode == null || !CATEGORIES.equals(categoriesNode.getNodeName())) {
            throw new IllegalArgumentException("No input categories node specified for parsing");
        }
        this.initialize();
        ArrayList<Category> cCategories = new ArrayList<Category>(5);
        NodeList categoryNodes = categoriesNode.getChildNodes();
        for (int i = 0; i < categoryNodes.getLength(); ++i) {
            Node categoryNode = categoryNodes.item(i);
            if (categoryNode == null) continue;
            Category category = this.categoryXmlFormat.parse(categoryNode);
            cCategories.add(category);
        }
        return new Categories(cCategories);
    }

    private void initialize() {
        if (this.categoryXmlFormat == null) {
            this.categoryXmlFormat = new CategoryXmlFormat();
        }
    }
}

