/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;

public class JGitPathImpl
extends AbstractPath<JGitFileSystem>
implements SegmentedPath {
    private static final int BUFFER_SIZE = 8192;
    public static final String DEFAULT_REF_TREE = "master";
    private final ObjectId objectId;

    private JGitPathImpl(JGitFileSystem fs, String path, String host, ObjectId id, boolean isRoot, boolean isRealPath, boolean isNormalized) {
        super((FileSystem)fs, path, host, isRoot, isRealPath, isNormalized);
        this.objectId = id;
    }

    protected AbstractPath.RootInfo setupRoot(JGitFileSystem fs, String pathx, String host, boolean isRoot) {
        boolean isRooted = isRoot ? true : pathx.startsWith("/");
        boolean isAbsolute = isRooted;
        int lastOffset = isAbsolute ? 1 : 0;
        boolean isFinalRoot = pathx.length() == 1 && lastOffset == 1 ? true : isRoot;
        return new AbstractPath.RootInfo(lastOffset, isAbsolute, isFinalRoot, pathx.getBytes());
    }

    protected String defaultDirectory() {
        return "/:";
    }

    protected Path newRoot(JGitFileSystem fs, String substring, String host, boolean realPath) {
        return new JGitPathImpl(fs, substring, host, null, true, realPath, true);
    }

    protected Path newPath(JGitFileSystem fs, String substring, String host, boolean isRealPath, boolean isNormalized) {
        return new JGitPathImpl(fs, substring, host, null, false, isRealPath, isNormalized);
    }

    public static JGitPathImpl create(JGitFileSystem fs, String path, String host, ObjectId id, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), id, false, isRealPath, false);
    }

    public static JGitPathImpl create(JGitFileSystem fs, String path, String host, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), null, false, isRealPath, false);
    }

    public static JGitPathImpl createRoot(JGitFileSystem fs, String path, String host, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), null, true, isRealPath, true);
    }

    public static JGitPathImpl createFSDirect(JGitFileSystem fs) {
        return new JGitPathImpl(fs, null, null, null, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File toFile() throws UnsupportedOperationException {
        if (this.file == null) {
            JGitPathImpl jGitPathImpl = this;
            synchronized (jGitPathImpl) {
                if (this.isRegularFile()) {
                    try {
                        this.file = File.createTempFile("git", "temp");
                        InputStream in = ((JGitFileSystem)this.getFileSystem()).provider().newInputStream((Path)this, new OpenOption[0]);
                        FileOutputStream out = new FileOutputStream(this.file);
                        JGitPathImpl.internalCopy(in, out);
                        in.close();
                        ((OutputStream)out).close();
                    }
                    catch (Exception ex) {
                        this.file = null;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this.file;
    }

    private static String setupHost(String host) {
        if (!host.contains("@")) {
            return "master@" + host;
        }
        return host;
    }

    private static String setupPath(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    public String getRefTree() {
        return this.host.substring(0, this.host.indexOf("@"));
    }

    public String getPath() {
        return new String(this.path);
    }

    public boolean isRegularFile() throws IllegalAccessError, SecurityException {
        try {
            return ((JGitFileSystem)this.getFileSystem()).provider().readAttributes((Path)this, BasicFileAttributes.class, new LinkOption[0]).isRegularFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static long internalCopy(InputStream in, OutputStream out) {
        long read = 0L;
        byte[] buf = new byte[8192];
        try {
            int n;
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
                read += (long)n;
            }
        }
        catch (java.io.IOException e) {
            throw new IOException((Exception)e);
        }
        return read;
    }

    public String getSegmentId() {
        return this.getRefTree();
    }
}

