/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.regex.AntPathMatcher;
import org.uberfire.java.nio.file.Path;

public abstract class BaseFilteredServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(BaseFilteredServlet.class);
    protected Collection<String> includes = new ArrayList<String>();
    protected Collection<String> excludes = new ArrayList<String>();

    public void init(ServletConfig config) throws ServletException {
        String _excludes;
        super.init(config);
        String _includes = config.getInitParameter("includes-path");
        if (_includes != null && !_includes.trim().isEmpty()) {
            this.includes.addAll(Arrays.asList(_includes.split(",")));
        }
        if ((_excludes = config.getInitParameter("excludes-path")) != null && !_excludes.trim().isEmpty()) {
            this.excludes.addAll(Arrays.asList(_excludes.split(",")));
        }
    }

    protected boolean validateAccess(URI uri, HttpServletResponse response) {
        if (!AntPathMatcher.filter(this.includes, this.excludes, (URI)uri)) {
            logger.error("Invalid credentials to path.");
            try {
                response.sendError(403);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    protected boolean validateAccess(Path path, HttpServletResponse response) {
        if (!AntPathMatcher.filter(this.includes, this.excludes, (Path)path)) {
            logger.error("Invalid credentials to path.");
            try {
                response.sendError(403);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
            return false;
        }
        return true;
    }
}

