/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.workbench.common.services.backend.validation.asset.Filter;
import org.kie.workbench.common.services.backend.validation.asset.NoProjectException;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class ValidatorFileSystemProvider {
    private final KieFileSystem kieFileSystem;
    private final IOService ioService;
    private final org.uberfire.backend.vfs.Path resourcePath;
    private final Filter filter;
    private final InputStream resource;
    private final KieProject project;

    public ValidatorFileSystemProvider(org.uberfire.backend.vfs.Path resourcePath, InputStream resource, KieProject project, IOService ioService, Filter filter) throws NoProjectException {
        if (project == null) {
            throw new NoProjectException();
        }
        this.resourcePath = resourcePath;
        this.resource = resource;
        this.project = project;
        this.kieFileSystem = KieServices.Factory.get().newKieFileSystem();
        this.ioService = ioService;
        this.filter = filter;
    }

    public void write() {
        this.kieFileSystem.write(this.getDestinationPath(), KieServices.Factory.get().getResources().newInputStreamResource((InputStream)new BufferedInputStream(this.resource)));
        this.visitPaths(this.getProjectDirectoryStream());
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (!this.filter.accept(path)) continue;
            this.kieFileSystem.write(this.getDestinationPath(path), KieServices.Factory.get().getResources().newInputStreamResource((InputStream)new BufferedInputStream(this.ioService.newInputStream(path, new OpenOption[0]))));
        }
    }

    private DirectoryStream<Path> getProjectDirectoryStream() {
        return Files.newDirectoryStream((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.project.getRootPath()));
    }

    private int getRootPathLength() {
        return this.project.getRootPath().toURI().length() + 1;
    }

    private String getDestinationPath(Path path) {
        return path.toUri().toString().substring(this.getRootPathLength());
    }

    public String getDestinationPath() {
        return this.resourcePath.toURI().substring(this.getRootPathLength());
    }

    public KieFileSystem getFileSystem() {
        return this.kieFileSystem;
    }
}

