/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.archive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.guvnor.common.services.backend.archive.Archiver;
import org.uberfire.server.BaseFilteredServlet;

public class ArchiveServlet
extends BaseFilteredServlet {
    @Inject
    private Archiver archiver;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getParameter("attachmentPath");
        try {
            if (uri != null) {
                String downLoadFileName;
                if (!this.validateAccess(new URI(uri), response)) {
                    return;
                }
                int index = uri.lastIndexOf("@") + 1;
                if (index < 0) {
                    index = 0;
                }
                if ((downLoadFileName = uri.substring(index)).startsWith("/")) {
                    downLoadFileName = downLoadFileName.substring(1);
                }
                if (downLoadFileName.endsWith("/")) {
                    downLoadFileName = downLoadFileName.substring(0, downLoadFileName.length() - 1);
                }
                downLoadFileName.replaceAll("/", "_");
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.archiver.archive(outputStream, uri);
                response.setContentType("application/zip");
                response.setHeader("Content-Disposition", "attachment; filename=" + downLoadFileName + ".zip");
                response.setContentLength(outputStream.size());
                response.getOutputStream().write(outputStream.toByteArray());
                response.getOutputStream().flush();
            } else {
                response.sendError(400);
            }
        }
        catch (URISyntaxException e) {
            response.sendError(400);
        }
    }
}

