/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.events;

import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

@Portable
public class DataModelerEvent {
    protected DataObject currentDataObject;
    protected ObjectProperty currentField;
    protected Project currentProject;
    protected String source;
    protected String contextId;
    public static final String DATA_MODEL_BROWSER = "DATA_MODEL_BROWSER";
    public static final String DATA_OBJECT_BROWSER = "DATA_OBJECT_BROWSER";
    public static final String DATA_OBJECT_EDITOR = "DATA_OBJECT_EDITOR";

    public DataModelerEvent() {
    }

    public DataModelerEvent(String contextId, String source, DataObject currentDataObject) {
        this(contextId, source, currentDataObject, null);
    }

    public DataModelerEvent(String source, DataObject currentDataObject) {
        this(null, source, currentDataObject, null);
    }

    public DataModelerEvent(String contextId, String source, DataObject currentDataObject, ObjectProperty currentField) {
        this.contextId = contextId;
        this.source = source;
        this.currentDataObject = currentDataObject;
        this.currentField = currentField;
    }

    public DataModelerEvent(String contextId, Project currentProject, DataObject currentDataObject) {
        this.contextId = contextId;
        this.currentProject = currentProject;
        this.currentDataObject = currentDataObject;
    }

    public DataModelerEvent(Project currentProject, DataObject currentDataObject) {
        this.currentProject = currentProject;
        this.currentDataObject = currentDataObject;
    }

    public DataObject getCurrentDataObject() {
        return this.currentDataObject;
    }

    public void setCurrentDataObject(DataObject currentDataObject) {
        this.currentDataObject = currentDataObject;
    }

    public DataModelerEvent withCurrentDataObject(DataObject currentDataObject) {
        this.setCurrentDataObject(currentDataObject);
        return this;
    }

    public ObjectProperty getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(ObjectProperty currentField) {
        this.currentField = currentField;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    public boolean isFrom(Project project) {
        return this.currentProject != null && this.currentProject.equals((Object)project);
    }

    public boolean isFrom(String source) {
        return this.source != null && this.source.equals(source);
    }

    public boolean isFromContext(String contextId) {
        return this.contextId != null && this.contextId.equals(contextId);
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }
}

