/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfoPerCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.util.SetOnce;

public abstract class MergePolicy
implements Closeable,
Cloneable {
    protected SetOnce<IndexWriter> writer = new SetOnce();

    public MergePolicy clone() {
        MergePolicy clone;
        try {
            clone = (MergePolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.writer = new SetOnce();
        return clone;
    }

    public void setIndexWriter(IndexWriter writer) {
        this.writer.set(writer);
    }

    public abstract MergeSpecification findMerges(SegmentInfos var1) throws IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentInfoPerCommit, Boolean> var3) throws IOException;

    public abstract MergeSpecification findForcedDeletesMerges(SegmentInfos var1) throws IOException;

    @Override
    public abstract void close();

    public abstract boolean useCompoundFile(SegmentInfos var1, SegmentInfoPerCommit var2) throws IOException;

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge merge) {
            this.merges.add(merge);
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString(dir));
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentInfoPerCommit info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public long estimatedMergeBytes;
        List<SegmentReader> readers;
        public final List<SegmentInfoPerCommit> segments;
        public final int totalDocCount;
        boolean aborted;
        Throwable error;
        boolean paused;

        public OneMerge(List<SegmentInfoPerCommit> segments) {
            if (0 == segments.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentInfoPerCommit>(segments);
            int count = 0;
            for (SegmentInfoPerCommit info : segments) {
                count += info.info.getDocCount();
            }
            this.totalDocCount = count;
        }

        synchronized void setException(Throwable error) {
            this.error = error;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        synchronized void abort() {
            this.aborted = true;
            this.notifyAll();
        }

        synchronized boolean isAborted() {
            return this.aborted;
        }

        public synchronized void checkAborted(Directory dir) throws MergeAbortedException {
            if (this.aborted) {
                throw new MergeAbortedException("merge is aborted: " + this.segString(dir));
            }
            while (this.paused) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                if (!this.aborted) continue;
                throw new MergeAbortedException("merge is aborted: " + this.segString(dir));
            }
        }

        public synchronized void setPause(boolean paused) {
            this.paused = paused;
            if (!paused) {
                this.notifyAll();
            }
        }

        public synchronized boolean getPause() {
            return this.paused;
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.get(i).toString(dir, 0));
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.info.name);
            }
            if (this.maxNumSegments != -1) {
                b.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.aborted) {
                b.append(" [ABORTED]");
            }
            return b.toString();
        }

        public long totalBytesSize() throws IOException {
            long total = 0L;
            for (SegmentInfoPerCommit info : this.segments) {
                total += info.info.sizeInBytes();
            }
            return total;
        }

        public int totalNumDocs() throws IOException {
            int total = 0;
            for (SegmentInfoPerCommit info : this.segments) {
                total += info.info.getDocCount();
            }
            return total;
        }

        public MergeInfo getMergeInfo() {
            return new MergeInfo(this.totalDocCount, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }
    }
}

