/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.utils.IdentifierUtils;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.kie.workbench.common.services.backend.project.KieResourceResolver;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;

public class ProjectSaver {
    private IOService ioService;
    private POMService pomService;
    private KModuleService kModuleService;
    private Event<NewProjectEvent> newProjectEvent;
    private Event<NewPackageEvent> newPackageEvent;
    private KieResourceResolver resourceResolver;
    private ProjectImportsService projectImportsService;
    private ProjectRepositoriesService projectRepositoriesService;
    private PackageNameWhiteListService packageNameWhiteListService;
    private CommentedOptionFactory commentedOptionFactory;
    private SafeSessionInfo safeSessionInfo;

    public ProjectSaver() {
    }

    @Inject
    public ProjectSaver(@Named(value="ioStrategy") IOService ioService, POMService pomService, KModuleService kModuleService, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, KieResourceResolver resourceResolver, ProjectImportsService projectImportsService, ProjectRepositoriesService projectRepositoriesService, PackageNameWhiteListService packageNameWhiteListService, CommentedOptionFactory commentedOptionFactory, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.newProjectEvent = newProjectEvent;
        this.newPackageEvent = newPackageEvent;
        this.resourceResolver = resourceResolver;
        this.projectImportsService = projectImportsService;
        this.projectRepositoriesService = projectRepositoriesService;
        this.packageNameWhiteListService = packageNameWhiteListService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public KieProject save(org.uberfire.backend.vfs.Path repositoryRoot, POM pom, String baseUrl) {
        try {
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot).getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption("New project [" + pom.getName() + "]")});
            KieProject kieProject = new NewProjectCreator(pom, repositoryRoot).create(baseUrl);
            this.newProjectEvent.fire((Object)new NewProjectEvent((Project)kieProject, this.safeSessionInfo.getId(), this.safeSessionInfo.getIdentity().getIdentifier()));
            KieProject kieProject2 = kieProject;
            return kieProject2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private class NewProjectCreator {
        private final org.uberfire.backend.vfs.Path repositoryRoot;
        private final org.uberfire.backend.vfs.Path projectRootPath;
        private final POM pom;
        private final KieProject simpleProjectInstance;
        private final Path projectNioRootPath;

        public NewProjectCreator(POM pom, org.uberfire.backend.vfs.Path repositoryRoot) {
            this.repositoryRoot = repositoryRoot;
            this.pom = pom;
            String projectName = pom.getName();
            if (projectName == null || projectName.isEmpty()) {
                projectName = pom.getGav().getArtifactId();
            }
            this.projectNioRootPath = Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot).resolve(projectName);
            this.projectRootPath = Paths.convert((Path)this.projectNioRootPath);
            this.simpleProjectInstance = ProjectSaver.this.resourceResolver.simpleProjectInstance(Paths.convert((org.uberfire.backend.vfs.Path)this.projectRootPath));
        }

        public KieProject create(String baseUrl) {
            this.createKieProject(baseUrl);
            return ProjectSaver.this.resourceResolver.resolveProject(this.projectRootPath);
        }

        private org.uberfire.backend.vfs.Path createKieProject(String baseUrl) {
            this.updateParentPOM();
            ProjectSaver.this.pomService.create(this.projectRootPath, baseUrl, this.pom);
            this.createMavenDirectories();
            ProjectSaver.this.kModuleService.setUpKModule(this.simpleProjectInstance.getKModuleXMLPath());
            this.createDefaultPackage();
            ProjectSaver.this.projectImportsService.saveProjectImports(this.simpleProjectInstance.getImportsPath());
            ProjectSaver.this.packageNameWhiteListService.createProjectWhiteList(this.simpleProjectInstance.getPackageNamesWhiteListPath());
            ProjectSaver.this.projectRepositoriesService.create(this.simpleProjectInstance.getRepositoriesPath());
            return this.projectRootPath;
        }

        private void updateParentPOM() {
            org.uberfire.backend.vfs.Path parentPom = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.repositoryRoot).resolve("pom.xml"));
            if (ProjectSaver.this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)parentPom))) {
                POM parent = (POM)ProjectSaver.this.pomService.load(parentPom);
                parent.setPackaging("pom");
                parent.getModules().add(this.pom.getName());
                this.pom.setParent(parent.getGav());
                ProjectSaver.this.pomService.save(parentPom, (Object)parent, null, "Adding child module " + this.pom.getName());
            }
        }

        private void createMavenDirectories() {
            ProjectSaver.this.ioService.createDirectory(this.projectNioRootPath.resolve("src/main/java"), new FileAttribute[0]);
            ProjectSaver.this.ioService.createDirectory(this.projectNioRootPath.resolve("src/main/resources"), new FileAttribute[0]);
            ProjectSaver.this.ioService.createDirectory(this.projectNioRootPath.resolve("src/test/java"), new FileAttribute[0]);
            ProjectSaver.this.ioService.createDirectory(this.projectNioRootPath.resolve("src/test/resources"), new FileAttribute[0]);
        }

        private void createDefaultPackage() {
            ProjectSaver.this.newPackageEvent.fire((Object)new NewPackageEvent(ProjectSaver.this.resourceResolver.newPackage(this.getDefaultPackage(), this.getDefaultWorkspacePath(), false)));
        }

        private Package getDefaultPackage() {
            return ProjectSaver.this.resourceResolver.resolvePackage(Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.projectRootPath).resolve("src/main/resources")));
        }

        private String getDefaultWorkspacePath() {
            return StringUtils.join((Object[])this.getLegalId(this.pom.getGav().getGroupId()), (String)"/") + "/" + StringUtils.join((Object[])this.getLegalId(this.pom.getGav().getArtifactId()), (String)"/");
        }

        private String[] getLegalId(String id) {
            return IdentifierUtils.convertMavenIdentifierToJavaIdentifier((String[])id.split("\\.", -1));
        }
    }
}

