/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.io.File;
import java.io.IOException;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtils {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static boolean isFileName(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (value.startsWith(".") || value.endsWith(".")) {
            return false;
        }
        char[] cArray = ILLEGAL_CHARACTERS;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!value.contains(c.toString())) continue;
            return false;
        }
        File f = new File(value);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isJavaIdentifier(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (!SourceVersion.isIdentifier(value) || SourceVersion.isKeyword(value)) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (CharUtils.isAsciiPrintable((char)value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isArtifactIdentifier(String value) {
        return value != null && value.matches("[A-Za-z0-9_\\-.]+");
    }
}

